/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.catalog.oceanbase.converter;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Objects;
import java.util.regex.Pattern;
import org.apache.gravitino.catalog.jdbc.converter.JdbcColumnDefaultValueConverter;
import org.apache.gravitino.catalog.jdbc.converter.JdbcTypeConverter;
import org.apache.gravitino.rel.Column;
import org.apache.gravitino.rel.expressions.Expression;
import org.apache.gravitino.rel.expressions.UnparsedExpression;
import org.apache.gravitino.rel.expressions.literals.Literals;
import org.apache.gravitino.rel.types.Decimal;
import org.apache.gravitino.rel.types.Type;
import org.apache.gravitino.rel.types.Types;

public class OceanBaseColumnDefaultValueConverter
extends JdbcColumnDefaultValueConverter {
    private static final Pattern CURRENT_TIMESTAMP = Pattern.compile("^CURRENT_TIMESTAMP(\\(\\d+\\))?$");

    public Expression toGravitino(JdbcTypeConverter.JdbcTypeBean type, String columnDefaultValue, boolean isExpression, boolean nullable) {
        if (Objects.isNull(columnDefaultValue)) {
            return nullable ? Literals.NULL : Column.DEFAULT_VALUE_NOT_SET;
        }
        if (columnDefaultValue.equalsIgnoreCase("NULL")) {
            return Literals.NULL;
        }
        if (isExpression) {
            if (CURRENT_TIMESTAMP.matcher(columnDefaultValue).matches()) {
                return Column.DEFAULT_VALUE_OF_CURRENT_TIMESTAMP;
            }
            return UnparsedExpression.of((String)columnDefaultValue);
        }
        switch (type.getTypeName().toLowerCase()) {
            case "tinyint": {
                return Literals.byteLiteral((Byte)Byte.valueOf(columnDefaultValue));
            }
            case "tinyint unsigned": {
                return Literals.unsignedByteLiteral((Short)Short.valueOf(columnDefaultValue));
            }
            case "smallint": {
                return Literals.shortLiteral((Short)Short.valueOf(columnDefaultValue));
            }
            case "smallint unsigned": {
                return Literals.unsignedShortLiteral((Integer)Integer.valueOf(columnDefaultValue));
            }
            case "int": {
                return Literals.integerLiteral((Integer)Integer.valueOf(columnDefaultValue));
            }
            case "int unsigned": {
                return Literals.unsignedIntegerLiteral((Long)Long.valueOf(columnDefaultValue));
            }
            case "bigint": {
                return Literals.longLiteral((Long)Long.valueOf(columnDefaultValue));
            }
            case "bigint unsigned": {
                return Literals.unsignedLongLiteral((Decimal)Decimal.of((String)columnDefaultValue));
            }
            case "float": {
                return Literals.floatLiteral((Float)Float.valueOf(columnDefaultValue));
            }
            case "double": {
                return Literals.doubleLiteral((Double)Double.valueOf(columnDefaultValue));
            }
            case "number": 
            case "numeric": 
            case "decimal": {
                return Literals.decimalLiteral((Decimal)Decimal.of((String)columnDefaultValue, (int)type.getColumnSize(), (int)type.getScale()));
            }
            case "date": {
                return Literals.dateLiteral((LocalDate)LocalDate.parse(columnDefaultValue, DATE_FORMATTER));
            }
            case "time": {
                return Literals.timeLiteral((LocalTime)LocalTime.parse(columnDefaultValue, DATE_TIME_FORMATTER));
            }
            case "timestamp": 
            case "datetime": {
                return CURRENT_TIMESTAMP.matcher(columnDefaultValue).matches() ? Column.DEFAULT_VALUE_OF_CURRENT_TIMESTAMP : Literals.timestampLiteral((LocalDateTime)LocalDateTime.parse(columnDefaultValue, DATE_TIME_FORMATTER));
            }
            case "varchar": {
                return Literals.of((Object)columnDefaultValue, (Type)Types.VarCharType.of((int)type.getColumnSize()));
            }
            case "char": {
                return Literals.of((Object)columnDefaultValue, (Type)Types.FixedCharType.of((int)type.getColumnSize()));
            }
            case "text": {
                return Literals.stringLiteral((String)columnDefaultValue);
            }
        }
        return UnparsedExpression.of((String)columnDefaultValue);
    }
}

