/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.serializer.fory;

import org.apache.fory.ThreadSafeFory;
import org.apache.seata.common.loader.LoadLevel;
import org.apache.seata.core.protocol.AbstractMessage;
import org.apache.seata.core.serializer.Serializer;
import org.apache.seata.serializer.fory.ForySerializerFactory;

@LoadLevel(name="FORY")
public class ForySerializer
implements Serializer {
    public <T> byte[] serialize(T t) {
        if (!(t instanceof AbstractMessage)) {
            throw new IllegalArgumentException("AbstractMessage isn't available.");
        }
        ThreadSafeFory threadSafeFory = ForySerializerFactory.getInstance().get();
        return threadSafeFory.serialize(t);
    }

    public <T> T deserialize(byte[] bytes) {
        if (bytes == null || bytes.length == 0) {
            throw new IllegalArgumentException("bytes is null");
        }
        ThreadSafeFory threadSafeFory = ForySerializerFactory.getInstance().get();
        return (T)threadSafeFory.deserialize(bytes);
    }
}

