/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.namingserver.manager;

import jakarta.annotation.PostConstruct;
import jakarta.servlet.AsyncContext;
import jakarta.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.seata.namingserver.listener.ClusterChangeEvent;
import org.apache.seata.namingserver.listener.ClusterChangeListener;
import org.apache.seata.namingserver.listener.Watcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.event.EventListener;
import org.springframework.http.HttpStatus;
import org.springframework.scheduling.annotation.Async;
import org.springframework.scheduling.concurrent.CustomizableThreadFactory;
import org.springframework.stereotype.Component;

@Component
public class ClusterWatcherManager
implements ClusterChangeListener {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final Map<String, Queue<Watcher<?>>> WATCHERS = new ConcurrentHashMap();
    private static final Map<String, Long> GROUP_UPDATE_TERM = new ConcurrentHashMap();
    private final ScheduledThreadPoolExecutor scheduledThreadPoolExecutor = new ScheduledThreadPoolExecutor(1, (ThreadFactory)new CustomizableThreadFactory("long-polling"));

    @PostConstruct
    public void init() {
        this.scheduledThreadPoolExecutor.scheduleAtFixedRate(() -> {
            for (String group : WATCHERS.keySet()) {
                Optional.ofNullable((Queue)WATCHERS.remove(group)).ifPresent(watchers -> watchers.parallelStream().forEach(watcher -> {
                    if (System.currentTimeMillis() >= watcher.getTimeout()) {
                        this.notify(watcher, HttpStatus.NOT_MODIFIED.value());
                    }
                    if (!watcher.isDone()) {
                        this.registryWatcher(watcher);
                    }
                }));
            }
        }, 1L, 1L, TimeUnit.SECONDS);
    }

    @EventListener
    @Async
    public void onChangeEvent(ClusterChangeEvent event) {
        if (event.getTerm() > 0L || event.getTerm() == -1L) {
            GROUP_UPDATE_TERM.put(event.getGroup(), event.getTerm());
            Optional.ofNullable((Queue)WATCHERS.remove(event.getGroup())).ifPresent(watchers -> watchers.parallelStream().forEach(arg_0 -> this.notify(arg_0)));
        }
    }

    private void notify(Watcher<?> watcher) {
        this.notify(watcher, 200);
    }

    private void notify(Watcher<?> watcher, int statusCode) {
        AsyncContext asyncContext = (AsyncContext)watcher.getAsyncContext();
        HttpServletResponse httpServletResponse = (HttpServletResponse)asyncContext.getResponse();
        watcher.setDone(true);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("notify cluster change event to: {}", (Object)asyncContext.getRequest().getRemoteAddr());
        }
        httpServletResponse.setStatus(statusCode);
        asyncContext.complete();
    }

    public void registryWatcher(Watcher<?> watcher) {
        String group = watcher.getGroup();
        Long term = (Long)GROUP_UPDATE_TERM.get(group);
        if (term == null || watcher.getTerm() >= term) {
            WATCHERS.computeIfAbsent(group, value -> new ConcurrentLinkedQueue()).add(watcher);
        } else {
            this.notify(watcher);
        }
    }

    public List<String> getWatcherIpList(String vGroup) {
        HashSet<String> watcherIpSet = new HashSet<String>();
        Queue watcherQueue = (Queue)WATCHERS.get(vGroup);
        for (Watcher watcher : watcherQueue) {
            watcherIpSet.add(watcher.getClientEndpoint());
        }
        return new ArrayList<String>(watcherIpSet);
    }

    public List<String> getWatchVGroupList() {
        return new ArrayList<String>(WATCHERS.keySet());
    }

    public long getTermByvGroup(String vGroup) {
        return GROUP_UPDATE_TERM.getOrDefault(vGroup, 0L);
    }
}

