/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.registry.client.event;

import com.alipay.sofa.registry.client.api.EventBus;
import com.alipay.sofa.registry.client.api.EventSubscriber;
import com.alipay.sofa.registry.client.api.RegistryClientConfig;
import com.alipay.sofa.registry.client.api.model.Event;
import com.alipay.sofa.registry.client.factory.NamedThreadFactory;
import com.alipay.sofa.registry.client.log.LoggerFactory;
import com.alipay.sofa.registry.client.util.CommonUtils;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;

public class DefaultEventBus
implements EventBus {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultEventBus.class);
    private RegistryClientConfig config;
    private ConcurrentMap<Class<? extends Event>, CopyOnWriteArraySet<EventSubscriber>> eventSubscriberMap = new ConcurrentHashMap<Class<? extends Event>, CopyOnWriteArraySet<EventSubscriber>>();
    private Executor executor;

    public DefaultEventBus(RegistryClientConfig config) {
        this.config = config;
        this.executor = new ThreadPoolExecutor(config.getObserverThreadCoreSize(), config.getObserverThreadMaxSize(), 0L, TimeUnit.SECONDS, new LinkedBlockingDeque<Runnable>(config.getObserverThreadQueueLength()), new NamedThreadFactory("DefaultEventBusThread"));
    }

    @Override
    public void register(Class<? extends Event> eventClass, EventSubscriber eventSubscriber) {
        CopyOnWriteArraySet old;
        CopyOnWriteArraySet<EventSubscriber> set = (CopyOnWriteArraySet<EventSubscriber>)this.eventSubscriberMap.get(eventClass);
        if (set == null && (old = this.eventSubscriberMap.putIfAbsent(eventClass, set = new CopyOnWriteArraySet<EventSubscriber>())) != null) {
            set = old;
        }
        set.add(eventSubscriber);
        LOGGER.debug("Register subscriber: {} of event: {}.", (Object)eventSubscriber, eventClass);
    }

    @Override
    public void unRegister(Class<? extends Event> eventClass, EventSubscriber eventSubscriber) {
        CopyOnWriteArraySet set = (CopyOnWriteArraySet)this.eventSubscriberMap.get(eventClass);
        if (set != null) {
            set.remove(eventSubscriber);
            LOGGER.debug("UnRegister subscriber: {} of event: {}.", (Object)eventSubscriber, eventClass);
        }
    }

    @Override
    public void post(final Event event) {
        if (!this.isEnable()) {
            return;
        }
        CopyOnWriteArraySet subscribers = (CopyOnWriteArraySet)this.eventSubscriberMap.get(event.getClass());
        if (null != subscribers && !subscribers.isEmpty()) {
            for (final EventSubscriber subscriber : subscribers) {
                if (subscriber.isSync()) {
                    this.handleEvent(subscriber, event);
                    continue;
                }
                this.executor.execute(new Runnable(){

                    @Override
                    public void run() {
                        DefaultEventBus.this.handleEvent(subscriber, event);
                    }
                });
            }
        }
    }

    @Override
    public boolean isEnable() {
        return null != this.config && this.config.isEventBusEnable();
    }

    @Override
    public boolean isEnable(Class<? extends Event> eventClass) {
        return this.isEnable() && CommonUtils.isNotEmpty((Collection)this.eventSubscriberMap.get(eventClass));
    }

    private void handleEvent(EventSubscriber subscriber, Event event) {
        try {
            subscriber.onEvent(event);
        }
        catch (Throwable e) {
            LOGGER.warn("Handle {} error", event.getClass(), (Object)e);
        }
    }
}

