/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fory.pool;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.fory.Fory;
import org.apache.fory.logging.Logger;
import org.apache.fory.logging.LoggerFactory;
import org.apache.fory.pool.ClassLoaderForyPooled;
import org.apache.fory.util.LoaderBinding;

public class ForyPooledObjectFactory {
    private static final Logger LOG = LoggerFactory.getLogger(ForyPooledObjectFactory.class);
    private final Function<ClassLoader, Fory> foryFactory;
    final Cache<ClassLoader, ClassLoaderForyPooled> classLoaderForyPooledCache;
    private volatile ClassLoader classLoader = null;
    private final ThreadLocal<ClassLoader> classLoaderLocal = ThreadLocal.withInitial(() -> {
        if (this.classLoader != null) {
            return this.classLoader;
        }
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (loader == null) {
            loader = Fory.class.getClassLoader();
        }
        return loader;
    });
    private final int minPoolSize;
    private final int maxPoolSize;
    private final Consumer<Fory> factoryCallback;

    public ForyPooledObjectFactory(Function<ClassLoader, Fory> foryFactory, int minPoolSize, int maxPoolSize, long expireTime, TimeUnit timeUnit, Consumer<Fory> factoryCallback) {
        this.minPoolSize = minPoolSize;
        this.maxPoolSize = maxPoolSize;
        this.foryFactory = foryFactory;
        this.factoryCallback = factoryCallback;
        this.classLoaderForyPooledCache = CacheBuilder.newBuilder().expireAfterAccess(expireTime, timeUnit).build();
    }

    public ClassLoaderForyPooled getPooledCache() {
        try {
            ClassLoader classLoader = this.classLoaderLocal.get();
            assert (classLoader != null);
            ClassLoaderForyPooled classLoaderForyPooled = (ClassLoaderForyPooled)this.classLoaderForyPooledCache.getIfPresent((Object)classLoader);
            if (classLoaderForyPooled == null) {
                return this.getOrAddCache(classLoader);
            }
            return classLoaderForyPooled;
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), e);
            throw new RuntimeException(e);
        }
    }

    public void setClassLoader(ClassLoader classLoader, LoaderBinding.StagingType stagingType) {
        if (classLoader == null) {
            classLoader = Fory.class.getClassLoader();
        }
        this.classLoader = classLoader;
        this.classLoaderLocal.set(classLoader);
        this.getOrAddCache(classLoader);
    }

    public ClassLoader getClassLoader() {
        return this.classLoaderLocal.get();
    }

    public void clearClassLoader(ClassLoader loader) {
        this.classLoaderForyPooledCache.invalidate((Object)loader);
        this.classLoaderLocal.remove();
    }

    private synchronized ClassLoaderForyPooled getOrAddCache(ClassLoader classLoader) {
        ClassLoaderForyPooled classLoaderForyPooled = (ClassLoaderForyPooled)this.classLoaderForyPooledCache.getIfPresent((Object)classLoader);
        if (classLoaderForyPooled == null) {
            classLoaderForyPooled = new ClassLoaderForyPooled(classLoader, this.foryFactory, this.minPoolSize, this.maxPoolSize);
            classLoaderForyPooled.setFactoryCallback(this.factoryCallback);
            this.classLoaderForyPooledCache.put((Object)classLoader, (Object)classLoaderForyPooled);
        }
        return classLoaderForyPooled;
    }
}

