/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.core.rpc.netty.grpc;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http2.Http2DataFrame;
import io.netty.handler.codec.http2.Http2HeadersFrame;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.ReferenceCounted;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.seata.core.compressor.Compressor;
import org.apache.seata.core.compressor.CompressorFactory;
import org.apache.seata.core.protocol.HeartbeatMessage;
import org.apache.seata.core.protocol.RpcMessage;
import org.apache.seata.core.protocol.generated.GrpcMessageProto;
import org.apache.seata.core.rpc.netty.grpc.GrpcHeaderEnum;
import org.apache.seata.core.serializer.Serializer;
import org.apache.seata.core.serializer.SerializerServiceLoader;
import org.apache.seata.core.serializer.SerializerType;

public class GrpcDecoder
extends ChannelDuplexHandler {
    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (msg instanceof Http2HeadersFrame) {
            this.onHeadersRead(ctx, (Http2HeadersFrame)msg);
        } else if (msg instanceof Http2DataFrame) {
            this.onDataRead(ctx, (Http2DataFrame)msg);
        } else if (msg instanceof ReferenceCounted) {
            ReferenceCountUtil.release((Object)msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onDataRead(ChannelHandlerContext ctx, Http2DataFrame msg) throws Exception {
        ByteBuf content = msg.content();
        try {
            int length;
            int readableBytes = content.readableBytes();
            byte[] bytes = new byte[readableBytes];
            content.readBytes(bytes);
            if (bytes.length < 5) {
                return;
            }
            for (int srcPos = 0; srcPos < readableBytes; srcPos += length + 5) {
                length = (bytes[srcPos + 1] & 0xFF) << 24 | (bytes[srcPos + 2] & 0xFF) << 16 | (bytes[srcPos + 3] & 0xFF) << 8 | bytes[srcPos + 4] & 0xFF;
                byte[] data = new byte[length];
                System.arraycopy(bytes, srcPos + 5, data, 0, length);
                GrpcMessageProto grpcMessageProto = GrpcMessageProto.parseFrom(data);
                byte[] bodyBytes = grpcMessageProto.getBody().toByteArray();
                int messageType = grpcMessageProto.getMessageType();
                int messageId = grpcMessageProto.getId();
                Map<String, String> headMap = grpcMessageProto.getHeadMapMap();
                RpcMessage rpcMsg = new RpcMessage();
                if (messageType <= 127 && messageType >= -128) {
                    rpcMsg.setMessageType((byte)messageType);
                }
                rpcMsg.setId(messageId);
                rpcMsg.setHeadMap(grpcMessageProto.getHeadMapMap());
                if (messageType == 3) {
                    rpcMsg.setBody(HeartbeatMessage.PING);
                } else if (messageType == 4) {
                    rpcMsg.setBody(HeartbeatMessage.PONG);
                } else {
                    String codecValue;
                    String compressType = headMap.get(GrpcHeaderEnum.COMPRESS_TYPE.header);
                    if (StringUtils.isNotBlank((CharSequence)compressType)) {
                        byte compress = Byte.parseByte(compressType);
                        rpcMsg.setCompressor(compress);
                        Compressor compressor = CompressorFactory.getCompressor(compress);
                        bodyBytes = compressor.decompress(bodyBytes);
                    }
                    int codec = StringUtils.isBlank((CharSequence)(codecValue = headMap.get(GrpcHeaderEnum.CODEC_TYPE.header))) ? SerializerType.GRPC.getCode() : Integer.parseInt(codecValue);
                    SerializerType serializerType = SerializerType.getByCode(codec);
                    rpcMsg.setCodec(serializerType.getCode());
                    Serializer serializer = SerializerServiceLoader.load(serializerType);
                    Object messageBody = serializer.deserialize(bodyBytes);
                    rpcMsg.setBody(messageBody);
                }
                ctx.fireChannelRead((Object)rpcMsg);
            }
        }
        finally {
            ReferenceCountUtil.release((Object)content);
        }
    }

    public void onHeadersRead(ChannelHandlerContext ctx, Http2HeadersFrame headersFrame) throws Exception {
    }
}

