/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.server.limit.ratelimit;

import io.github.bucket4j.Bandwidth;
import io.github.bucket4j.Bucket;
import io.github.bucket4j.Refill;
import io.github.bucket4j.local.LocalBucket;
import java.time.Duration;
import org.apache.seata.common.executor.Initialize;
import org.apache.seata.common.loader.LoadLevel;
import org.apache.seata.common.loader.Scope;
import org.apache.seata.common.util.NumberUtils;
import org.apache.seata.config.Configuration;
import org.apache.seata.config.ConfigurationFactory;
import org.apache.seata.server.limit.ratelimit.RateLimiter;
import org.apache.seata.server.limit.ratelimit.RateLimiterHandlerConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@LoadLevel(name="token-bucket-limiter", scope=Scope.SINGLETON)
public class TokenBucketLimiter
implements RateLimiter,
Initialize {
    private static final Logger LOGGER = LoggerFactory.getLogger(TokenBucketLimiter.class);
    private boolean enable;
    private Integer bucketTokenNumPerSecond;
    private Integer bucketTokenMaxNum;
    private Integer bucketTokenInitialNum;
    private Bucket bucket;
    private static final int DEFAULT_BUCKET_TOKEN_NUM_PER_SECOND = Integer.MAX_VALUE;
    private static final int DEFAULT_BUCKET_TOKEN_MAX_NUM = Integer.MAX_VALUE;
    private static final int DEFAULT_BUCKET_TOKEN_INITIAL_NUM = Integer.MAX_VALUE;

    public TokenBucketLimiter() {
    }

    public TokenBucketLimiter(boolean enable, Integer bucketTokenNumPerSecond, Integer bucketTokenMaxNum, Integer bucketTokenInitialNum) {
        this.enable = enable;
        this.bucketTokenNumPerSecond = bucketTokenNumPerSecond;
        this.bucketTokenMaxNum = bucketTokenMaxNum;
        this.bucketTokenInitialNum = bucketTokenInitialNum;
        this.initBucket();
    }

    public void init() {
        Configuration config = ConfigurationFactory.getInstance();
        this.enable = config.getBoolean("server.ratelimit.enable");
        this.bucketTokenNumPerSecond = NumberUtils.toInt((String)config.getConfig("server.ratelimit.bucketTokenNumPerSecond"), (int)Integer.MAX_VALUE);
        this.bucketTokenMaxNum = NumberUtils.toInt((String)config.getConfig("server.ratelimit.bucketTokenMaxNum"), (int)Integer.MAX_VALUE);
        this.bucketTokenInitialNum = NumberUtils.toInt((String)config.getConfig("server.ratelimit.bucketTokenInitialNum"), (int)Integer.MAX_VALUE);
        if (this.enable) {
            this.initBucket();
            LOGGER.info("TokenBucketLimiter init success, bucketTokenNumPerSecond: {}, tokenMaxNum: {}, tokenInitialNum: {}", new Object[]{this.bucketTokenNumPerSecond, this.bucketTokenMaxNum, this.bucketTokenInitialNum});
        }
    }

    public boolean canPass() {
        return this.bucket.tryConsume(1L);
    }

    public void reInit(RateLimiterHandlerConfig config) {
        this.enable = config.isEnable();
        this.bucketTokenNumPerSecond = config.getBucketTokenNumPerSecond();
        this.bucketTokenMaxNum = config.getBucketTokenMaxNum();
        this.bucketTokenInitialNum = config.getBucketTokenInitialNum();
        if (this.enable) {
            this.initBucket();
            LOGGER.info("TokenBucketLimiter reInit success, bucketTokenNumPerSecond: {}, tokenMaxNum: {}, tokenInitialNum: {}", new Object[]{this.bucketTokenNumPerSecond, this.bucketTokenMaxNum, this.bucketTokenInitialNum});
            return;
        }
        LOGGER.info("TokenBucketLimiter reInit success, The limiter is disabled");
    }

    public RateLimiterHandlerConfig obtainConfig() {
        RateLimiterHandlerConfig config = new RateLimiterHandlerConfig();
        config.setEnable(this.enable);
        config.setBucketTokenNumPerSecond(this.bucketTokenNumPerSecond.intValue());
        config.setBucketTokenMaxNum(this.bucketTokenMaxNum.intValue());
        config.setBucketTokenInitialNum(this.bucketTokenInitialNum.intValue());
        return config;
    }

    public boolean isEnable() {
        return this.enable;
    }

    private void initBucket() {
        Bandwidth limit = Bandwidth.classic((long)this.bucketTokenMaxNum.intValue(), (Refill)Refill.greedy((long)this.bucketTokenNumPerSecond.intValue(), (Duration)Duration.ofSeconds(1L)));
        LocalBucket bucket = Bucket.builder().addLimit(limit).build();
        if (this.bucketTokenInitialNum > 0) {
            bucket.addTokens((long)this.bucketTokenInitialNum.intValue());
        }
        this.bucket = bucket;
    }
}

