/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.server.storage.file.store;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.seata.common.exception.StoreException;
import org.apache.seata.common.thread.NamedThreadFactory;
import org.apache.seata.common.util.BufferUtils;
import org.apache.seata.common.util.CollectionUtils;
import org.apache.seata.server.session.BranchSession;
import org.apache.seata.server.session.GlobalSession;
import org.apache.seata.server.session.SessionCondition;
import org.apache.seata.server.session.SessionManager;
import org.apache.seata.server.storage.file.FlushDiskMode;
import org.apache.seata.server.storage.file.ReloadableStore;
import org.apache.seata.server.storage.file.TransactionWriteStore;
import org.apache.seata.server.storage.file.store.FileTransactionStoreManager;
import org.apache.seata.server.store.AbstractTransactionStoreManager;
import org.apache.seata.server.store.SessionStorable;
import org.apache.seata.server.store.StoreConfig;
import org.apache.seata.server.store.TransactionStoreManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class FileTransactionStoreManager
extends AbstractTransactionStoreManager
implements TransactionStoreManager,
ReloadableStore {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileTransactionStoreManager.class);
    private static final int MAX_THREAD_WRITE = 1;
    private ExecutorService fileWriteExecutor;
    private volatile boolean stopping = false;
    private static final int MAX_SHUTDOWN_RETRY = 3;
    private static final int SHUTDOWN_CHECK_INTERVAL = 1000;
    private static final int MAX_WRITE_RETRY = 5;
    private static final String HIS_DATA_FILENAME_POSTFIX = ".1";
    private static final AtomicLong FILE_TRX_NUM = new AtomicLong(0L);
    private static final AtomicLong FILE_FLUSH_NUM = new AtomicLong(0L);
    private static final int MARK_SIZE = 4;
    private static final int MAX_WAIT_TIME_MILLS = 2000;
    private static final int MAX_FLUSH_TIME_MILLS = 2000;
    private static final int MAX_FLUSH_NUM = 10;
    private static final int PER_FILE_BLOCK_SIZE = 524280;
    private static final long MAX_TRX_TIMEOUT_MILLS = 1800000L;
    private static volatile long trxStartTimeMills = System.currentTimeMillis();
    private File currDataFile;
    private RandomAccessFile currRaf;
    private FileChannel currFileChannel;
    private long recoverCurrOffset = 0L;
    private long recoverHisOffset = 0L;
    private SessionManager sessionManager;
    private String currFullFileName;
    private String hisFullFileName;
    private WriteDataFileRunnable writeDataFileRunnable;
    private ReentrantLock writeSessionLock = new ReentrantLock();
    private volatile long lastModifiedTime;
    private static final int MAX_WRITE_BUFFER_SIZE = StoreConfig.getFileWriteBufferCacheSize();
    private final ByteBuffer writeBuffer = ByteBuffer.allocateDirect(MAX_WRITE_BUFFER_SIZE);
    private static final FlushDiskMode FLUSH_DISK_MODE = StoreConfig.getFlushDiskMode();
    private static final int MAX_WAIT_FOR_FLUSH_TIME_MILLS = 2000;
    private static final int MAX_WAIT_FOR_CLOSE_TIME_MILLS = 2000;
    private static final int INT_BYTE_SIZE = 4;

    public FileTransactionStoreManager(String fullFileName, SessionManager sessionManager) throws IOException {
        this.initFile(fullFileName);
        this.fileWriteExecutor = new ThreadPoolExecutor(1, 1, Integer.MAX_VALUE, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)new NamedThreadFactory("fileTransactionStore", 1, true));
        this.writeDataFileRunnable = new WriteDataFileRunnable(this);
        this.fileWriteExecutor.submit((Runnable)this.writeDataFileRunnable);
        this.sessionManager = sessionManager;
    }

    private void initFile(String fullFileName) throws IOException {
        this.currFullFileName = fullFileName;
        this.hisFullFileName = fullFileName + HIS_DATA_FILENAME_POSTFIX;
        try {
            this.currDataFile = new File(this.currFullFileName);
            if (!this.currDataFile.exists()) {
                if (this.currDataFile.getParentFile() != null && !this.currDataFile.getParentFile().exists()) {
                    this.currDataFile.getParentFile().mkdirs();
                }
                this.currDataFile.createNewFile();
                trxStartTimeMills = System.currentTimeMillis();
            } else {
                trxStartTimeMills = this.currDataFile.lastModified();
            }
            this.lastModifiedTime = System.currentTimeMillis();
            this.currRaf = new RandomAccessFile(this.currDataFile, "rw");
            this.currRaf.seek(this.currDataFile.length());
            this.currFileChannel = this.currRaf.getChannel();
        }
        catch (IOException exx) {
            LOGGER.error("init file error,{}", (Object)exx.getMessage(), (Object)exx);
            throw exx;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean writeSession(TransactionStoreManager.LogOperation logOperation, SessionStorable session) {
        long curFileTrxNum;
        this.writeSessionLock.lock();
        try {
            if (!this.writeDataFile(new TransactionWriteStore(session, logOperation).encode())) {
                boolean bl = false;
                return bl;
            }
            this.lastModifiedTime = System.currentTimeMillis();
            curFileTrxNum = FILE_TRX_NUM.incrementAndGet();
            if (curFileTrxNum % 524280L == 0L && System.currentTimeMillis() - trxStartTimeMills > 1800000L) {
                boolean bl = this.saveHistory();
                return bl;
            }
        }
        catch (Exception exx) {
            LOGGER.error("writeSession error, {}", (Object)exx.getMessage(), (Object)exx);
            boolean bl = false;
            return bl;
        }
        finally {
            this.writeSessionLock.unlock();
        }
        this.flushDisk(curFileTrxNum, this.currFileChannel);
        return true;
    }

    private void flushDisk(long curFileNum, FileChannel currFileChannel) {
        if (FLUSH_DISK_MODE == FlushDiskMode.SYNC_MODEL) {
            SyncFlushRequest syncFlushRequest = new SyncFlushRequest(this, curFileNum, currFileChannel);
            this.writeDataFileRunnable.putRequest((StoreRequest)syncFlushRequest);
            syncFlushRequest.waitForFlush(2000L);
        } else {
            this.writeDataFileRunnable.putRequest((StoreRequest)new AsyncFlushRequest(this, curFileNum, currFileChannel));
        }
    }

    private boolean saveHistory() throws IOException {
        boolean result;
        try {
            result = this.findTimeoutAndSave();
            CloseFileRequest request = new CloseFileRequest(this.currFileChannel, this.currRaf);
            this.writeDataFileRunnable.putRequest((StoreRequest)request);
            request.waitForClose(2000L);
            Files.move(this.currDataFile.toPath(), new File(this.hisFullFileName).toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException exx) {
            LOGGER.error("save history data file error, {}", (Object)exx.getMessage(), (Object)exx);
            result = false;
        }
        finally {
            this.initFile(this.currFullFileName);
        }
        return result;
    }

    private boolean writeDataFrame(byte[] data) {
        int dataLengthToWrite;
        if (data == null || data.length <= 0) {
            return true;
        }
        int dataLength = data.length;
        int bufferRemainingSize = this.writeBuffer.remaining();
        if (bufferRemainingSize <= 4 && !this.flushWriteBuffer(this.writeBuffer)) {
            return false;
        }
        bufferRemainingSize = this.writeBuffer.remaining();
        if (bufferRemainingSize <= 4) {
            throw new IllegalStateException(String.format("Write buffer remaining size %d was too small", bufferRemainingSize));
        }
        this.writeBuffer.putInt(dataLength);
        bufferRemainingSize = this.writeBuffer.remaining();
        for (int dataPos = 0; dataPos < dataLength; dataPos += dataLengthToWrite) {
            dataLengthToWrite = dataLength - dataPos;
            dataLengthToWrite = Math.min(dataLengthToWrite, bufferRemainingSize);
            this.writeBuffer.put(data, dataPos, dataLengthToWrite);
            bufferRemainingSize = this.writeBuffer.remaining();
            if (bufferRemainingSize != 0) continue;
            if (!this.flushWriteBuffer(this.writeBuffer)) {
                return false;
            }
            bufferRemainingSize = this.writeBuffer.remaining();
        }
        return true;
    }

    private boolean flushWriteBuffer(ByteBuffer writeBuffer) {
        BufferUtils.flip((Buffer)writeBuffer);
        if (!this.writeDataFileByBuffer(writeBuffer)) {
            return false;
        }
        BufferUtils.clear((Buffer)writeBuffer);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean findTimeoutAndSave() throws IOException {
        List globalSessionsOverMaxTimeout = this.sessionManager.findGlobalSessions(new SessionCondition(1800000L));
        if (CollectionUtils.isEmpty((Collection)globalSessionsOverMaxTimeout)) {
            return true;
        }
        for (GlobalSession globalSession : globalSessionsOverMaxTimeout) {
            TransactionWriteStore globalWriteStore = new TransactionWriteStore((SessionStorable)globalSession, TransactionStoreManager.LogOperation.GLOBAL_ADD);
            byte[] data = globalWriteStore.encode();
            if (!this.writeDataFrame(data)) {
                return false;
            }
            List branchSessIonsOverMaXTimeout = globalSession.getSortedBranches();
            if (branchSessIonsOverMaXTimeout == null) continue;
            for (BranchSession branchSession : branchSessIonsOverMaXTimeout) {
                try {
                    MDC.put((String)"X-TX-BRANCH-ID", (String)String.valueOf(branchSession.getBranchId()));
                    TransactionWriteStore branchWriteStore = new TransactionWriteStore((SessionStorable)branchSession, TransactionStoreManager.LogOperation.BRANCH_ADD);
                    data = branchWriteStore.encode();
                    if (this.writeDataFrame(data)) continue;
                    boolean bl = false;
                    return bl;
                }
                finally {
                    MDC.remove((String)"X-TX-BRANCH-ID");
                }
            }
        }
        if (this.flushWriteBuffer(this.writeBuffer)) {
            this.currFileChannel.force(false);
            return true;
        }
        return false;
    }

    public GlobalSession readSession(String xid) {
        throw new StoreException("unsupport for read from file, xid:" + xid);
    }

    public List<GlobalSession> readSession(SessionCondition sessionCondition) {
        throw new StoreException("unsupport for read from file");
    }

    public void shutdown() {
        if (this.fileWriteExecutor != null) {
            this.fileWriteExecutor.shutdown();
            this.stopping = true;
            int retry = 0;
            while (!this.fileWriteExecutor.isTerminated() && retry < 3) {
                ++retry;
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
            if (retry >= 3) {
                this.fileWriteExecutor.shutdownNow();
            }
        }
        try {
            if (this.currFileChannel.isOpen()) {
                this.currFileChannel.force(true);
            }
        }
        catch (IOException e) {
            LOGGER.error("fileChannel force error: {}", (Object)e.getMessage(), (Object)e);
        }
        this.closeFile(this.currRaf);
    }

    public List<TransactionWriteStore> readWriteStore(int readSize, boolean isHistory) {
        File file = null;
        long currentOffset = 0L;
        if (isHistory) {
            file = new File(this.hisFullFileName);
            currentOffset = this.recoverHisOffset;
        } else {
            file = new File(this.currFullFileName);
            currentOffset = this.recoverCurrOffset;
        }
        if (file.exists()) {
            return this.parseDataFile(file, readSize, currentOffset, isHistory);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * WARNING - bad return control flow
     */
    public boolean hasRemaining(boolean isHistory) {
        boolean bl;
        long currentOffset;
        File file;
        RandomAccessFile raf = null;
        if (isHistory) {
            file = new File(this.hisFullFileName);
            currentOffset = this.recoverHisOffset;
        } else {
            file = new File(this.currFullFileName);
            currentOffset = this.recoverCurrOffset;
        }
        try {
            raf = new RandomAccessFile(file, "r");
            bl = currentOffset < raf.length();
        }
        catch (IOException iOException) {
            this.closeFile(raf);
            catch (Throwable throwable) {
                this.closeFile(raf);
                throw throwable;
            }
        }
        this.closeFile(raf);
        return bl;
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<TransactionWriteStore> parseDataFile(File file, int readSize, long currentOffset, boolean isHistory) {
        ArrayList<TransactionWriteStore> transactionWriteStores = new ArrayList<TransactionWriteStore>(readSize);
        RandomAccessFile raf = null;
        FileChannel fileChannel = null;
        try {
            raf = new RandomAccessFile(file, "r");
            raf.seek(currentOffset);
            fileChannel = raf.getChannel();
            fileChannel.position(currentOffset);
            long size = raf.length();
            ByteBuffer buffSize = ByteBuffer.allocate(4);
            while (fileChannel.position() < size) {
                try {
                    BufferUtils.clear((Buffer)buffSize);
                    int avilReadSize = fileChannel.read(buffSize);
                    if (avilReadSize != 4) break;
                    BufferUtils.flip((Buffer)buffSize);
                    int bodySize = buffSize.getInt();
                    byte[] byBody = new byte[bodySize];
                    ByteBuffer buffBody = ByteBuffer.wrap(byBody);
                    avilReadSize = fileChannel.read(buffBody);
                    if (avilReadSize != bodySize) break;
                    TransactionWriteStore writeStore = new TransactionWriteStore();
                    writeStore.decode(byBody);
                    transactionWriteStores.add(writeStore);
                    if (transactionWriteStores.size() != readSize) continue;
                    break;
                }
                catch (Exception ex) {
                    LOGGER.error("decode data file error:{}", (Object)ex.getMessage(), (Object)ex);
                    break;
                }
            }
            ArrayList<TransactionWriteStore> arrayList = transactionWriteStores;
            return arrayList;
        }
        catch (IOException exx) {
            LOGGER.error("parse data file error:{},file:{}", new Object[]{exx.getMessage(), file.getName(), exx});
            List<TransactionWriteStore> list = null;
            return list;
        }
        finally {
            try {
                if (fileChannel != null) {
                    if (isHistory) {
                        this.recoverHisOffset = fileChannel.position();
                    } else {
                        this.recoverCurrOffset = fileChannel.position();
                    }
                }
                this.closeFile(raf);
            }
            catch (IOException exx) {
                LOGGER.error("file close error{}", (Object)exx.getMessage(), (Object)exx);
            }
        }
    }

    private void closeFile(RandomAccessFile raf) {
        try {
            if (raf != null) {
                raf.close();
                raf = null;
            }
        }
        catch (IOException exx) {
            LOGGER.error("file close error,{}", (Object)exx.getMessage(), (Object)exx);
        }
    }

    private boolean writeDataFile(byte[] bs) {
        if (bs == null || bs.length >= 0x7FFFFFFC) {
            return false;
        }
        if (!this.writeDataFrame(bs)) {
            return false;
        }
        return this.flushWriteBuffer(this.writeBuffer);
    }

    private boolean writeDataFileByBuffer(ByteBuffer byteBuffer) {
        for (int retry = 0; retry < 5; ++retry) {
            try {
                while (byteBuffer.hasRemaining()) {
                    this.currFileChannel.write(byteBuffer);
                }
                return true;
            }
            catch (Exception exx) {
                LOGGER.error("write data file error:{}", (Object)exx.getMessage(), (Object)exx);
                continue;
            }
        }
        LOGGER.error("write dataFile failed,retry more than :{}", (Object)5);
        return false;
    }

    static /* synthetic */ Logger access$000() {
        return LOGGER;
    }

    static /* synthetic */ boolean access$100(FileTransactionStoreManager x0) {
        return x0.stopping;
    }

    static /* synthetic */ FileChannel access$200(FileTransactionStoreManager x0) {
        return x0.currFileChannel;
    }

    static /* synthetic */ AtomicLong access$300() {
        return FILE_TRX_NUM;
    }

    static /* synthetic */ AtomicLong access$400() {
        return FILE_FLUSH_NUM;
    }

    static /* synthetic */ void access$500(FileTransactionStoreManager x0, RandomAccessFile x1) {
        x0.closeFile(x1);
    }

    static /* synthetic */ FlushDiskMode access$600() {
        return FLUSH_DISK_MODE;
    }

    static /* synthetic */ long access$700(FileTransactionStoreManager x0) {
        return x0.lastModifiedTime;
    }
}

