/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.common.util;

import org.apache.seata.common.util.StringUtils;

public class NumberUtils {
    public static int toInt(String str, int defaultValue) {
        if (str == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(str);
        }
        catch (NumberFormatException nfe) {
            return defaultValue;
        }
    }

    public static Long toLong(String str, Long defaultValue) {
        if (str == null) {
            return defaultValue;
        }
        try {
            return Long.valueOf(str);
        }
        catch (NumberFormatException nfe) {
            return defaultValue;
        }
    }

    public static Long toLong(String str) {
        if (StringUtils.isNotBlank(str)) {
            return Long.valueOf(str);
        }
        return null;
    }
}

