/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.common.util;

import org.apache.seata.common.util.NumberUtils;

public class SizeUtil {
    private static final long RADIX = 1024L;

    public static long size2Long(String size) {
        long number;
        if (null == size || size.length() <= 1) {
            throw new IllegalArgumentException("could not convert '" + size + "' to byte length");
        }
        String size2Lower = size.toLowerCase();
        char unit = size2Lower.charAt(size.length() - 1);
        try {
            number = NumberUtils.toLong(size2Lower.substring(0, size.length() - 1));
        }
        catch (NullPointerException | NumberFormatException ex) {
            throw new IllegalArgumentException("could not convert '" + size + "' to byte length");
        }
        switch (unit) {
            case 'k': {
                return number * 1024L;
            }
            case 'm': {
                return number * 1024L * 1024L;
            }
            case 'g': {
                return number * 1024L * 1024L * 1024L;
            }
            case 't': {
                return number * 1024L * 1024L * 1024L * 1024L;
            }
        }
        throw new IllegalArgumentException("could not convert '" + size + "' to byte length");
    }
}

