/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.main.sys;

import java.util.Set;
import org.apache.jena.atlas.logging.FmtLog;
import org.apache.jena.fuseki.Fuseki;
import org.apache.jena.fuseki.main.FusekiServer;
import org.apache.jena.fuseki.main.sys.FusekiModule;
import org.apache.jena.fuseki.main.sys.FusekiModules;
import org.apache.jena.fuseki.server.DataAccessPointRegistry;
import org.apache.jena.rdf.model.Model;

public class FusekiModuleStep {
    public static void prepare(FusekiModules modules, FusekiServer.Builder serverBuilder, Set<String> datasetNames, Model configModel) {
        modules.forEach(module -> module.prepare(serverBuilder, datasetNames, configModel));
    }

    public static void configured(FusekiModules modules, FusekiServer.Builder serverBuilder, DataAccessPointRegistry dapRegistry, Model configModel) {
        modules.forEach(module -> module.configured(serverBuilder, dapRegistry, configModel));
    }

    public static void server(FusekiServer server) {
        server.getModules().forEach(module -> module.server(server));
    }

    public static void serverBeforeStarting(FusekiServer server) {
        server.getModules().forEach(module -> module.serverBeforeStarting(server));
    }

    public static void serverAfterStarting(FusekiServer server) {
        server.getModules().forEach(module -> module.serverAfterStarting(server));
    }

    public static void serverStopped(FusekiServer server) {
        server.getModules().forEach(module -> module.serverStopped(server));
    }

    public static boolean serverReload(FusekiServer server) {
        for (FusekiModule fmod : server.getModules().asList()) {
            if (fmod.serverConfirmReload(server)) continue;
            FmtLog.warn(Fuseki.configLog, "Can not reload : module %s", fmod.name());
            return false;
        }
        server.getModules().forEach(module -> module.serverReload(server));
        return true;
    }
}

