/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.helper;

import org.apache.juneau.BeanContext;
import org.apache.juneau.BeanMeta;
import org.apache.juneau.BeanPropertyMeta;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.FormattedRuntimeException;
import org.apache.juneau.annotation.Bean;

@Bean(bpi="type,properties")
public final class BeanDescription {
    public String type;
    public BeanPropertyDescription[] properties;

    public BeanDescription(Class<?> c) {
        this.type = c.getName();
        BeanMeta<?> bm = BeanContext.DEFAULT.getBeanMeta(c);
        if (bm == null) {
            throw new FormattedRuntimeException("Class ''{0}'' is not a valid bean.", c);
        }
        this.properties = new BeanPropertyDescription[bm.getPropertyMetas().size()];
        int i = 0;
        for (BeanPropertyMeta pm : bm.getPropertyMetas()) {
            this.properties[i++] = new BeanPropertyDescription(pm.getName(), pm.getClassMeta());
        }
    }

    public static class BeanPropertyDescription {
        public String name;
        public String type;

        public BeanPropertyDescription(String name, ClassMeta<?> type) {
            this.name = name;
            this.type = type.getSerializedClassMeta(null).toString();
        }
    }
}

