/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.html;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.juneau.BeanPropertyMeta;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.DefaultFilteringObjectMap;
import org.apache.juneau.ObjectMap;
import org.apache.juneau.PropertyStore;
import org.apache.juneau.annotation.ConfigurableContext;
import org.apache.juneau.html.AnchorText;
import org.apache.juneau.html.HtmlBeanPropertyMeta;
import org.apache.juneau.html.HtmlClassMeta;
import org.apache.juneau.html.HtmlCommon;
import org.apache.juneau.html.HtmlMetaProvider;
import org.apache.juneau.html.HtmlSchemaSerializer;
import org.apache.juneau.html.HtmlSerializerBuilder;
import org.apache.juneau.html.HtmlSerializerSession;
import org.apache.juneau.serializer.SerializerSessionArgs;
import org.apache.juneau.xml.XmlSerializer;

@ConfigurableContext
public class HtmlSerializer
extends XmlSerializer
implements HtmlMetaProvider,
HtmlCommon {
    static final String PREFIX = "HtmlSerializer";
    public static final String HTML_addBeanTypes = "HtmlSerializer.addBeanTypes.b";
    public static final String HTML_addKeyValueTableHeaders = "HtmlSerializer.addKeyValueTableHeaders.b";
    public static final String HTML_detectLinksInStrings = "HtmlSerializer.detectLinksInStrings.b";
    public static final String HTML_labelParameter = "HtmlSerializer.labelParameter.s";
    public static final String HTML_detectLabelParameters = "HtmlSerializer.detectLabelParameters.b";
    public static final String HTML_uriAnchorText = "HtmlSerializer.uriAnchorText.s";
    public static final HtmlSerializer DEFAULT = new HtmlSerializer(PropertyStore.DEFAULT);
    public static final HtmlSerializer DEFAULT_SQ = new Sq(PropertyStore.DEFAULT);
    public static final HtmlSerializer DEFAULT_SQ_READABLE = new SqReadable(PropertyStore.DEFAULT);
    private final AnchorText uriAnchorText;
    private final boolean detectLabelParameters;
    private final boolean detectLinksInStrings;
    private final boolean addKeyValueTableHeaders;
    private final boolean addBeanTypes;
    private final String labelParameter;
    private final Map<ClassMeta<?>, HtmlClassMeta> htmlClassMetas = new ConcurrentHashMap();
    private final Map<BeanPropertyMeta, HtmlBeanPropertyMeta> htmlBeanPropertyMetas = new ConcurrentHashMap<BeanPropertyMeta, HtmlBeanPropertyMeta>();
    private volatile HtmlSchemaSerializer schemaSerializer;

    public HtmlSerializer(PropertyStore ps) {
        this(ps, "text/html", null);
    }

    public HtmlSerializer(PropertyStore ps, String produces, String accept) {
        super(ps, produces, accept);
        this.uriAnchorText = this.getProperty(HTML_uriAnchorText, AnchorText.class, AnchorText.TO_STRING);
        this.detectLabelParameters = this.getBooleanProperty(HTML_detectLabelParameters, true);
        this.detectLinksInStrings = this.getBooleanProperty(HTML_detectLinksInStrings, true);
        this.labelParameter = this.getStringProperty(HTML_labelParameter, "label");
        this.addKeyValueTableHeaders = this.getBooleanProperty(HTML_addKeyValueTableHeaders, false);
        this.addBeanTypes = this.getBooleanProperty(HTML_addBeanTypes, this.getBooleanProperty("Serializer.addBeanTypes.b", false));
    }

    @Override
    public HtmlSerializerBuilder builder() {
        return new HtmlSerializerBuilder(this.getPropertyStore());
    }

    public static HtmlSerializerBuilder create() {
        return new HtmlSerializerBuilder();
    }

    @Override
    public HtmlSerializerSession createSession() {
        return this.createSession(this.createDefaultSessionArgs());
    }

    @Override
    public HtmlSerializerSession createSession(SerializerSessionArgs args) {
        return new HtmlSerializerSession(this, args);
    }

    @Override
    public HtmlSerializer getSchemaSerializer() {
        if (this.schemaSerializer == null) {
            this.schemaSerializer = this.builder().build(HtmlSchemaSerializer.class);
        }
        return this.schemaSerializer;
    }

    @Override
    public HtmlClassMeta getHtmlClassMeta(ClassMeta<?> cm) {
        HtmlClassMeta m = this.htmlClassMetas.get(cm);
        if (m == null) {
            m = new HtmlClassMeta(cm, this);
            this.htmlClassMetas.put(cm, m);
        }
        return m;
    }

    @Override
    public HtmlBeanPropertyMeta getHtmlBeanPropertyMeta(BeanPropertyMeta bpm) {
        if (bpm == null) {
            return HtmlBeanPropertyMeta.DEFAULT;
        }
        HtmlBeanPropertyMeta m = this.htmlBeanPropertyMetas.get(bpm);
        if (m == null) {
            m = new HtmlBeanPropertyMeta(bpm.getDelegateFor(), this);
            this.htmlBeanPropertyMetas.put(bpm, m);
        }
        return m;
    }

    @Override
    protected final boolean isAddBeanTypes() {
        return this.addBeanTypes;
    }

    protected final boolean isAddKeyValueTableHeaders() {
        return this.addKeyValueTableHeaders;
    }

    protected final boolean isDetectLabelParameters() {
        return this.detectLabelParameters;
    }

    protected final boolean isDetectLinksInStrings() {
        return this.detectLinksInStrings;
    }

    protected final String getLabelParameter() {
        return this.labelParameter;
    }

    protected final AnchorText getUriAnchorText() {
        return this.uriAnchorText;
    }

    @Override
    public ObjectMap toMap() {
        return super.toMap().append(PREFIX, new DefaultFilteringObjectMap().append("uriAnchorText", (Object)this.uriAnchorText).append("detectLabelParameters", this.detectLabelParameters).append("detectLinksInStrings", this.detectLinksInStrings).append("labelParameter", this.labelParameter).append("addKeyValueTableHeaders", this.addKeyValueTableHeaders).append("addBeanTypes", this.addBeanTypes));
    }

    public static class SqReadable
    extends HtmlSerializer {
        public SqReadable(PropertyStore ps) {
            super(ps.builder().set("WriterSerializer.quoteChar.s", Character.valueOf('\'')).set("WriterSerializer.useWhitespace.b", true).build());
        }
    }

    public static class Sq
    extends HtmlSerializer {
        public Sq(PropertyStore ps) {
            super(ps.builder().set("WriterSerializer.quoteChar.s", Character.valueOf('\'')).build());
        }
    }
}

