/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.http;

import java.util.Date;
import org.apache.juneau.http.HeaderString;
import org.apache.juneau.http.annotation.Header;
import org.apache.juneau.internal.DateUtils;
import org.apache.juneau.internal.StringUtils;

@Header(value="Retry-After")
public final class RetryAfter
extends HeaderString {
    public static RetryAfter forString(String value) {
        if (value == null) {
            return null;
        }
        return new RetryAfter(value);
    }

    private RetryAfter(String value) {
        super(value);
    }

    public Date asDate() {
        char c0 = StringUtils.charAt(this.value, 0);
        if (c0 >= '0' && c0 <= '9') {
            return null;
        }
        return DateUtils.parseDate(this.toString());
    }

    public int asInt() {
        char c0 = StringUtils.charAt(this.value, 0);
        if (c0 >= '0' && c0 <= '9') {
            try {
                return Integer.parseInt(this.value);
            }
            catch (NumberFormatException e) {
                return -1;
            }
        }
        return -1;
    }
}

