/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.vars;

import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.rest.RestRequest;
import org.apache.juneau.svl.MultipartResolvingVar;
import org.apache.juneau.svl.VarResolverSession;

public class RequestVar
extends MultipartResolvingVar {
    private static final String SESSION_req = "req";
    private static final String SESSION_res = "res";
    public static final String NAME = "R";

    public RequestVar() {
        super(NAME);
    }

    protected boolean allowNested() {
        return false;
    }

    protected boolean allowRecurse() {
        return false;
    }

    public String resolve(VarResolverSession session, String key) {
        RestRequest req = (RestRequest)((Object)session.getSessionObject(RestRequest.class, SESSION_req, true));
        char c = StringUtils.charAt((String)key, (int)0);
        if (c == 'a') {
            if ("authorityPath".equals(key)) {
                return req.getAuthorityPath();
            }
        } else if (c == 'c') {
            if ("contextPath".equals(key)) {
                return req.getContextPath();
            }
        } else if (c == 'm') {
            if ("method".equals(key)) {
                return req.getMethod();
            }
            if ("methodDescription".equals(key)) {
                return req.getMethodDescription();
            }
            if ("methodSummary".equals(key)) {
                return req.getMethodSummary();
            }
        } else if (c == 'p') {
            if ("pathInfo".equals(key)) {
                return req.getPathInfo();
            }
        } else if (c == 'r') {
            if ("requestParentURI".equals(key)) {
                return req.getUriContext().getRootRelativePathInfoParent();
            }
            if ("requestURI".equals(key)) {
                return req.getRequestURI();
            }
            if ("resourceDescription".equals(key)) {
                return req.getResourceDescription();
            }
            if ("resourceTitle".equals(key)) {
                return req.getResourceTitle();
            }
        } else if (c == 's') {
            if ("servletClass".equals(key)) {
                return req.getContext().getResource().getClass().getName();
            }
            if ("servletClassSimple".equals(key)) {
                return req.getContext().getResource().getClass().getSimpleName();
            }
            if ("servletParentURI".equals(key)) {
                return req.getUriContext().getRootRelativeServletPathParent();
            }
            if ("servletPath".equals(key)) {
                return req.getServletPath();
            }
            if ("servletURI".equals(key)) {
                return req.getUriContext().getRootRelativeServletPath();
            }
            if ("siteName".equals(key)) {
                return req.getSiteName();
            }
        }
        return req.getAttributes().getString(key);
    }

    public boolean canResolve(VarResolverSession session) {
        return session.hasSessionObject(SESSION_req) && session.hasSessionObject(SESSION_res);
    }
}

