/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals.graph;

import java.util.Set;
import org.apache.kafka.streams.internals.ApiUtils;
import org.apache.kafka.streams.processor.ConnectedStoreProvider;
import org.apache.kafka.streams.processor.api.FixedKeyProcessorSupplier;
import org.apache.kafka.streams.processor.api.ProcessorSupplier;
import org.apache.kafka.streams.processor.internals.InternalTopologyBuilder;
import org.apache.kafka.streams.state.StoreBuilder;

public class ProcessorParameters<KIn, VIn, KOut, VOut> {
    private final ProcessorSupplier<KIn, VIn, KOut, VOut> processorSupplier;
    private final FixedKeyProcessorSupplier<KIn, VIn, VOut> fixedKeyProcessorSupplier;
    private final String processorName;

    public ProcessorParameters(ProcessorSupplier<KIn, VIn, KOut, VOut> processorSupplier, String processorName) {
        this.processorSupplier = processorSupplier;
        this.fixedKeyProcessorSupplier = null;
        this.processorName = processorName;
    }

    public ProcessorParameters(FixedKeyProcessorSupplier<KIn, VIn, VOut> processorSupplier, String processorName) {
        this.processorSupplier = null;
        this.fixedKeyProcessorSupplier = processorSupplier;
        this.processorName = processorName;
    }

    public ProcessorSupplier<KIn, VIn, KOut, VOut> processorSupplier() {
        return this.processorSupplier;
    }

    public FixedKeyProcessorSupplier<KIn, VIn, VOut> fixedKeyProcessorSupplier() {
        return this.fixedKeyProcessorSupplier;
    }

    public void addProcessorTo(InternalTopologyBuilder topologyBuilder, String ... parentNodeNames) {
        Set<StoreBuilder<?>> stores;
        ConnectedStoreProvider wrapped;
        if (this.processorSupplier != null) {
            ApiUtils.checkSupplier(this.processorSupplier);
            wrapped = topologyBuilder.wrapProcessorSupplier(this.processorName, this.processorSupplier);
            topologyBuilder.addProcessor(this.processorName, (ProcessorSupplier<?, ?, ?, ?>)wrapped, parentNodeNames);
            stores = wrapped.stores();
            if (stores != null) {
                for (StoreBuilder<?> storeBuilder : stores) {
                    topologyBuilder.addStateStore(storeBuilder, this.processorName);
                }
            }
        }
        if (this.fixedKeyProcessorSupplier != null) {
            ApiUtils.checkSupplier(this.fixedKeyProcessorSupplier);
            wrapped = topologyBuilder.wrapFixedKeyProcessorSupplier(this.processorName, this.fixedKeyProcessorSupplier);
            topologyBuilder.addProcessor(this.processorName, wrapped, parentNodeNames);
            stores = wrapped.stores();
            if (stores != null) {
                for (StoreBuilder<?> storeBuilder : stores) {
                    topologyBuilder.addStateStore(storeBuilder, this.processorName);
                }
            }
        }
    }

    public String processorName() {
        return this.processorName;
    }

    public String toString() {
        return "ProcessorParameters{processor supplier class=" + String.valueOf(this.processorSupplier != null ? this.processorSupplier.getClass() : "null") + ", fixed key processor supplier class=" + String.valueOf(this.fixedKeyProcessorSupplier != null ? this.fixedKeyProcessorSupplier.getClass() : "null") + ", processor name='" + this.processorName + "'}";
    }
}

