/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.runtime.isolation;

import java.net.URL;
import java.net.URLClassLoader;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import org.apache.kafka.connect.runtime.isolation.PluginClassLoader;
import org.apache.kafka.connect.runtime.isolation.PluginDesc;
import org.apache.kafka.connect.runtime.isolation.PluginScanResult;
import org.apache.kafka.connect.runtime.isolation.PluginType;
import org.apache.kafka.connect.runtime.isolation.PluginUtils;
import org.apache.kafka.connect.runtime.isolation.VersionedPluginLoadingException;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.artifact.versioning.VersionRange;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DelegatingClassLoader
extends URLClassLoader {
    private static final Logger log = LoggerFactory.getLogger(DelegatingClassLoader.class);
    private final ConcurrentMap<String, SortedMap<PluginDesc<?>, ClassLoader>> pluginLoaders = new ConcurrentHashMap();
    private final ConcurrentMap<String, String> aliases = new ConcurrentHashMap<String, String>();

    public DelegatingClassLoader(ClassLoader parent) {
        super(new URL[0], parent);
    }

    public DelegatingClassLoader() {
        this(DelegatingClassLoader.class.getClassLoader());
    }

    PluginClassLoader pluginClassLoader(String name, VersionRange range, Optional<ClassLoader> connectorLoader) {
        if (!PluginUtils.shouldLoadInIsolation(name)) {
            return null;
        }
        SortedMap inner = (SortedMap)this.pluginLoaders.get(name);
        if (inner == null) {
            return null;
        }
        ClassLoader pluginLoader = this.findPluginLoader(inner, name, range, connectorLoader);
        return pluginLoader instanceof PluginClassLoader ? (PluginClassLoader)pluginLoader : null;
    }

    ClassLoader connectorLoader(String classOrAlias, VersionRange range) {
        String fullName = this.aliases.getOrDefault(classOrAlias, classOrAlias);
        URLClassLoader classLoader = this.pluginClassLoader(fullName, range, Optional.empty());
        if (classLoader == null) {
            classLoader = this;
        }
        log.debug("Got plugin class loader: '{}' for connector: {}", (Object)classLoader, (Object)classOrAlias);
        return classLoader;
    }

    ClassLoader pluginLoader(String classOrAlias, VersionRange range, ClassLoader connectorLoader) {
        String fullName = this.aliases.getOrDefault(classOrAlias, classOrAlias);
        URLClassLoader classLoader = this.pluginClassLoader(fullName, range, Optional.ofNullable(connectorLoader));
        if (classLoader == null) {
            classLoader = this;
        }
        log.debug("Got plugin class loader: '{}' for plugin: {}", (Object)classLoader, (Object)classOrAlias);
        return classLoader;
    }

    ClassLoader connectorLoader(String connectorClassOrAlias) {
        return this.connectorLoader(connectorClassOrAlias, null);
    }

    String resolveFullClassName(String classOrAlias) {
        return this.aliases.getOrDefault(classOrAlias, classOrAlias);
    }

    PluginDesc<?> pluginDesc(String classOrAlias, String preferredLocation, Set<PluginType> allowedTypes) {
        if (classOrAlias == null) {
            return null;
        }
        String fullName = this.aliases.getOrDefault(classOrAlias, classOrAlias);
        SortedMap inner = (SortedMap)this.pluginLoaders.get(fullName);
        if (inner == null) {
            return null;
        }
        PluginDesc result = null;
        for (Map.Entry entry : inner.entrySet()) {
            if (!allowedTypes.contains((Object)((PluginDesc)entry.getKey()).type()) || !(result = (PluginDesc)entry.getKey()).location().equals(preferredLocation)) continue;
            return result;
        }
        return result;
    }

    private ClassLoader findPluginLoader(SortedMap<PluginDesc<?>, ClassLoader> loaders, String pluginName, VersionRange range, Optional<ClassLoader> connectorLoader) {
        if (range != null && range.getRecommendedVersion() != null) {
            throw new VersionedPluginLoadingException(String.format("A soft version range is not supported for plugin loading, this is an internal error as connect should automatically convert soft ranges to hard ranges. Provided soft version: %s ", range));
        }
        ClassLoader loader = null;
        for (Map.Entry<PluginDesc<?>, ClassLoader> entry : loaders.entrySet()) {
            if (range == null || range.containsVersion((ArtifactVersion)entry.getKey().encodedVersion())) {
                loader = entry.getValue();
            }
            if (!connectorLoader.isPresent() || !connectorLoader.get().equals(loader)) continue;
            break;
        }
        if (range != null && loader == null) {
            List<String> availableVersions = loaders.keySet().stream().map(PluginDesc::version).collect(Collectors.toList());
            throw new VersionedPluginLoadingException(String.format("Plugin %s not found that matches the version range %s, available versions: %s", pluginName, range, availableVersions), availableVersions);
        }
        return loader;
    }

    public void installDiscoveredPlugins(PluginScanResult scanResult) {
        scanResult.forEach(pluginDesc -> this.pluginLoaders.computeIfAbsent(pluginDesc.className(), k -> new TreeMap()).put(pluginDesc, pluginDesc.loader()));
        for (String string : this.pluginLoaders.keySet()) {
            log.info("Added plugin '{}'", (Object)string);
        }
        this.aliases.putAll(PluginUtils.computeAliases(scanResult));
        for (Map.Entry entry : this.aliases.entrySet()) {
            log.info("Added alias '{}' to plugin '{}'", entry.getKey(), entry.getValue());
        }
    }

    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        return this.loadVersionedPluginClass(name, null, resolve);
    }

    protected Class<?> loadVersionedPluginClass(String name, VersionRange range, boolean resolve) throws VersionedPluginLoadingException, ClassNotFoundException {
        Class<?> plugin;
        String fullName = this.aliases.getOrDefault(name, name);
        PluginClassLoader pluginLoader = this.pluginClassLoader(fullName, range, Optional.empty());
        if (pluginLoader != null) {
            log.trace("Retrieving loaded class '{}' from '{}'", (Object)name, (Object)pluginLoader);
            plugin = pluginLoader.loadClass(fullName, resolve);
        } else {
            plugin = super.loadClass(fullName, resolve);
            if (range == null) {
                return plugin;
            }
            this.verifyClasspathVersionedPlugin(fullName, plugin, range);
        }
        return plugin;
    }

    private void verifyClasspathVersionedPlugin(String fullName, Class<?> plugin, VersionRange range) throws VersionedPluginLoadingException {
        SortedMap scannedPlugin = (SortedMap)this.pluginLoaders.get(fullName);
        if (scannedPlugin == null) {
            throw new VersionedPluginLoadingException(String.format("Plugin %s is not part of Connect's plugin loading mechanism (ClassPath or Plugin Path)", fullName));
        }
        List<String> classpathPlugins = scannedPlugin.keySet().stream().filter(pluginDesc -> pluginDesc.location().equals("classpath")).map(PluginDesc::version).distinct().toList();
        if (classpathPlugins.size() > 1) {
            throw new VersionedPluginLoadingException(String.format("Plugin %s has multiple versions specified in class path, only one version is allowed in class path for loading a plugin with version range", fullName));
        }
        if (classpathPlugins.isEmpty()) {
            throw new VersionedPluginLoadingException("Invalid plugin found in classpath");
        }
        String pluginVersion = classpathPlugins.get(0);
        if (!range.containsVersion((ArtifactVersion)new DefaultArtifactVersion(pluginVersion))) {
            throw new VersionedPluginLoadingException(String.format("Plugin %s has version %s which does not match the required version range %s", fullName, pluginVersion, range), List.of(pluginVersion));
        }
    }

    static {
        ClassLoader.registerAsParallelCapable();
    }
}

