/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.pl;

import java.io.IOException;
import java.io.InputStream;
import java.util.Set;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.CharArraySet;
import org.apache.lucene.analysis.LowerCaseFilter;
import org.apache.lucene.analysis.StopFilter;
import org.apache.lucene.analysis.StopwordAnalyzerBase;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.WordlistLoader;
import org.apache.lucene.analysis.miscellaneous.SetKeywordMarkerFilter;
import org.apache.lucene.analysis.standard.StandardTokenizer;
import org.apache.lucene.analysis.stempel.StempelFilter;
import org.apache.lucene.analysis.stempel.StempelStemmer;
import org.apache.lucene.util.IOUtils;
import org.egothor.stemmer.Trie;

public final class PolishAnalyzer
extends StopwordAnalyzerBase {
    private final CharArraySet stemExclusionSet;
    private final Trie stemTable = DefaultsHolder.DEFAULT_TABLE;
    public static final String DEFAULT_STOPWORD_FILE = "stopwords.txt";
    public static final String DEFAULT_STEMMER_FILE = "stemmer_20000.tbl";

    public static CharArraySet getDefaultStopSet() {
        return DefaultsHolder.DEFAULT_STOP_SET;
    }

    public static Trie getDefaultTable() {
        return DefaultsHolder.DEFAULT_TABLE;
    }

    public PolishAnalyzer() {
        this(DefaultsHolder.DEFAULT_STOP_SET);
    }

    public PolishAnalyzer(CharArraySet stopwords) {
        this(stopwords, CharArraySet.EMPTY_SET);
    }

    public PolishAnalyzer(CharArraySet stopwords, CharArraySet stemExclusionSet) {
        super(stopwords);
        this.stemExclusionSet = CharArraySet.unmodifiableSet((CharArraySet)CharArraySet.copy((Set)stemExclusionSet));
    }

    protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
        StandardTokenizer source = new StandardTokenizer();
        Object result = new LowerCaseFilter((TokenStream)source);
        result = new StopFilter((TokenStream)result, this.stopwords);
        if (!this.stemExclusionSet.isEmpty()) {
            result = new SetKeywordMarkerFilter((TokenStream)result, this.stemExclusionSet);
        }
        result = new StempelFilter((TokenStream)result, new StempelStemmer(this.stemTable));
        return new Analyzer.TokenStreamComponents((Tokenizer)source, (TokenStream)result);
    }

    protected TokenStream normalize(String fieldName, TokenStream in) {
        return new LowerCaseFilter(in);
    }

    private static class DefaultsHolder {
        static final CharArraySet DEFAULT_STOP_SET;
        static final Trie DEFAULT_TABLE;

        private DefaultsHolder() {
        }

        static {
            try {
                DEFAULT_STOP_SET = WordlistLoader.getWordSet((InputStream)((InputStream)IOUtils.requireResourceNonNull((Object)PolishAnalyzer.class.getResourceAsStream(PolishAnalyzer.DEFAULT_STOPWORD_FILE), (String)PolishAnalyzer.DEFAULT_STOPWORD_FILE)), (String)"#");
            }
            catch (IOException ex) {
                throw new RuntimeException("Unable to load default stopword set", ex);
            }
            try {
                DEFAULT_TABLE = StempelStemmer.load(PolishAnalyzer.class.getResourceAsStream(PolishAnalyzer.DEFAULT_STEMMER_FILE));
            }
            catch (IOException ex) {
                throw new RuntimeException("Unable to load default stemming tables", ex);
            }
        }
    }
}

