/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.tests.mockfile;

import java.io.IOException;
import java.nio.file.FileStore;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.WatchService;
import java.nio.file.attribute.UserPrincipalLookupService;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import org.apache.lucene.tests.mockfile.FilterFileStore;
import org.apache.lucene.tests.mockfile.FilterFileSystemProvider;
import org.apache.lucene.tests.mockfile.FilterPath;

public class FilterFileSystem
extends FileSystem {
    protected final FilterFileSystemProvider parent;
    protected final FileSystem delegate;

    public FilterFileSystem(FilterFileSystemProvider parent, FileSystem delegate) {
        this.parent = Objects.requireNonNull(parent);
        this.delegate = Objects.requireNonNull(delegate);
    }

    @Override
    public FilterFileSystemProvider provider() {
        return this.parent;
    }

    @Override
    public void close() throws IOException {
        if (this.delegate == FileSystems.getDefault()) {
            this.parent.onClose();
        } else {
            try (FileSystem d = this.delegate;){
                assert (d != null);
                this.parent.onClose();
            }
        }
    }

    @Override
    public boolean isOpen() {
        return this.delegate.isOpen();
    }

    @Override
    public boolean isReadOnly() {
        return this.delegate.isReadOnly();
    }

    @Override
    public String getSeparator() {
        return this.delegate.getSeparator();
    }

    @Override
    public Iterable<Path> getRootDirectories() {
        Iterable<Path> roots = this.delegate.getRootDirectories();
        return () -> {
            final Iterator iterator = roots.iterator();
            return new Iterator<Path>(){

                @Override
                public boolean hasNext() {
                    return iterator.hasNext();
                }

                @Override
                public Path next() {
                    return FilterFileSystem.this.parent.wrapPath((Path)iterator.next());
                }

                @Override
                public void remove() {
                    iterator.remove();
                }
            };
        };
    }

    @Override
    public Iterable<FileStore> getFileStores() {
        Iterable<FileStore> fileStores = this.delegate.getFileStores();
        return () -> {
            final Iterator iterator = fileStores.iterator();
            return new Iterator<FileStore>(){

                @Override
                public boolean hasNext() {
                    return iterator.hasNext();
                }

                @Override
                public FileStore next() {
                    return new FilterFileStore(this, (FileStore)iterator.next(), FilterFileSystem.this.parent.getScheme()){};
                }

                @Override
                public void remove() {
                    iterator.remove();
                }
            };
        };
    }

    @Override
    public Set<String> supportedFileAttributeViews() {
        return this.delegate.supportedFileAttributeViews();
    }

    @Override
    public Path getPath(String first, String ... more) {
        return this.parent.wrapPath(this.delegate.getPath(first, more));
    }

    @Override
    public PathMatcher getPathMatcher(String syntaxAndPattern) {
        PathMatcher matcher = this.delegate.getPathMatcher(syntaxAndPattern);
        return path -> {
            if (path instanceof FilterPath) {
                return matcher.matches(((FilterPath)path).delegate);
            }
            return false;
        };
    }

    @Override
    public UserPrincipalLookupService getUserPrincipalLookupService() {
        return this.delegate.getUserPrincipalLookupService();
    }

    @Override
    public WatchService newWatchService() throws IOException {
        return this.delegate.newWatchService();
    }

    public FileSystem getDelegate() {
        return this.delegate;
    }
}

