/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Interfaces and implementations used by query node processors
 *
 * <h2>Query Node Processors</h2>
 *
 * <p>The package <code>org.apache.lucene.queryParser.processors</code> contains interfaces that
 * should be implemented by every query node processor.
 *
 * <p>The interface that every query node processor should implement is {@link
 * org.apache.lucene.queryparser.flexible.core.processors.QueryNodeProcessor}. A query node
 * processor should be used to process a {@link
 * org.apache.lucene.queryparser.flexible.core.nodes.QueryNode} tree. {@link
 * org.apache.lucene.queryparser.flexible.core.nodes.QueryNode} trees can be programmatically
 * created or generated by a text parser. See {@link
 * org.apache.lucene.queryparser.flexible.core.parser} for more details about text parsers.
 *
 * <p>A query node processor should be used to process a {@link
 * org.apache.lucene.queryparser.flexible.core.nodes.QueryNode} tree. {@link
 * org.apache.lucene.queryparser.flexible.core.nodes.QueryNode} trees can be programmatically
 * created or generated by a text parser. See {@link
 * org.apache.lucene.queryparser.flexible.core.parser} for more details about text parsers.
 *
 * <p>A pipeline of processors can be assembled using {@link
 * org.apache.lucene.queryparser.flexible.core.processors.QueryNodeProcessorPipeline}.
 *
 * <p>Implementors may want to extend {@link
 * org.apache.lucene.queryparser.flexible.core.processors.QueryNodeProcessorImpl}, which simplifies
 * the implementation, because it walks automatically the {@link
 * org.apache.lucene.queryparser.flexible.core.nodes.QueryNode}. See {@link
 * org.apache.lucene.queryparser.flexible.core.processors.QueryNodeProcessorImpl} for more details.
 */
package org.apache.lucene.queryparser.flexible.core.processors;
