/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.ja.dict;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.lucene.analysis.ja.dict.Dictionary;
import org.apache.lucene.analysis.ja.dict.TokenInfoFST;
import org.apache.lucene.analysis.util.CSVUtil;
import org.apache.lucene.util.IntsRefBuilder;
import org.apache.lucene.util.fst.FST;
import org.apache.lucene.util.fst.FSTCompiler;
import org.apache.lucene.util.fst.FSTReader;
import org.apache.lucene.util.fst.Outputs;
import org.apache.lucene.util.fst.PositiveIntOutputs;

public final class UserDictionary
implements Dictionary {
    private static final Pattern LINE_COMMENT = Pattern.compile("^#.*$");
    private static final Pattern WHITESPACE = Pattern.compile("\\s");
    private static final Pattern SPACES = Pattern.compile(" +");
    private final TokenInfoFST fst;
    private final int[][] segmentations;
    private final String[] data;
    private static final int CUSTOM_DICTIONARY_WORD_ID_OFFSET = 100000000;
    public static final int WORD_COST = -100000;
    public static final int LEFT_ID = 5;
    public static final int RIGHT_ID = 5;
    private static final int[][] EMPTY_RESULT = new int[0][];

    public static UserDictionary open(Reader reader) throws IOException {
        String line;
        BufferedReader br = new BufferedReader(reader);
        ArrayList<String[]> featureEntries = new ArrayList<String[]>();
        while ((line = br.readLine()) != null) {
            if ((line = LINE_COMMENT.matcher(line).replaceAll("")).trim().isEmpty()) continue;
            String[] values = CSVUtil.parse((String)line);
            featureEntries.add(values);
        }
        if (featureEntries.isEmpty()) {
            return null;
        }
        return new UserDictionary(featureEntries);
    }

    private UserDictionary(List<String[]> featureEntries) throws IOException {
        int wordId = 100000000;
        featureEntries.sort((left, right) -> left[0].compareTo(right[0]));
        ArrayList<CallSite> data = new ArrayList<CallSite>(featureEntries.size());
        ArrayList<int[]> segmentations = new ArrayList<int[]>(featureEntries.size());
        PositiveIntOutputs fstOutput = PositiveIntOutputs.getSingleton();
        FSTCompiler fstCompiler = new FSTCompiler.Builder(FST.INPUT_TYPE.BYTE2, (Outputs)fstOutput).build();
        IntsRefBuilder scratch = new IntsRefBuilder();
        long ord = 0L;
        for (String[] values : featureEntries) {
            String surface = WHITESPACE.matcher(values[0]).replaceAll("");
            String concatenatedSegment = WHITESPACE.matcher(values[1]).replaceAll("");
            String[] segmentation = SPACES.split(values[1]);
            String[] readings = SPACES.split(values[2]);
            String pos = values[3];
            if (segmentation.length != readings.length) {
                throw new RuntimeException("Illegal user dictionary entry " + values[0] + " - the number of segmentations (" + segmentation.length + ") does not the match number of readings (" + readings.length + ")");
            }
            if (!surface.equals(concatenatedSegment)) {
                throw new RuntimeException("Illegal user dictionary entry " + values[0] + " - the concatenated segmentation (" + concatenatedSegment + ") does not match the surface form (" + surface + ")");
            }
            int[] wordIdAndLength = new int[segmentation.length + 1];
            wordIdAndLength[0] = wordId;
            for (int i = 0; i < segmentation.length; ++i) {
                wordIdAndLength[i + 1] = segmentation[i].length();
                data.add((CallSite)((Object)(readings[i] + "\u0000" + pos)));
                ++wordId;
            }
            String token = values[0];
            scratch.growNoCopy(token.length());
            scratch.setLength(token.length());
            for (int i = 0; i < token.length(); ++i) {
                scratch.setIntAt(i, (int)token.charAt(i));
            }
            fstCompiler.add(scratch.get(), (Object)ord);
            segmentations.add(wordIdAndLength);
            ++ord;
        }
        this.fst = new TokenInfoFST((FST<Long>)FST.fromFSTReader((FST.FSTMetadata)fstCompiler.compile(), (FSTReader)fstCompiler.getFSTReader()), false);
        this.data = data.toArray(new String[0]);
        this.segmentations = (int[][])segmentations.toArray((T[])new int[0][]);
    }

    public int[][] lookup(char[] chars, int off, int len) throws IOException {
        ArrayList<Match> matches = null;
        int numResults = 0;
        FST.BytesReader fstReader = this.fst.getBytesReader();
        int end = off + len;
        FST.Arc<Long> arc = new FST.Arc<Long>();
        for (int startOffset = off; startOffset < end; ++startOffset) {
            char ch;
            int[] wordIdAndLength = null;
            arc = this.fst.getFirstArc(arc);
            int output = 0;
            int remaining = end - startOffset;
            for (int i = 0; i < remaining && this.fst.findTargetArc(ch = chars[startOffset + i], arc, arc, i == 0, fstReader) != null; ++i) {
                output += ((Long)arc.output()).intValue();
                if (!arc.isFinal()) continue;
                int finalOutput = output + ((Long)arc.nextFinalOutput()).intValue();
                wordIdAndLength = this.segmentations[finalOutput];
            }
            if (wordIdAndLength == null) continue;
            if (matches == null) {
                matches = new ArrayList<Match>();
            }
            matches.add(new Match(startOffset - off, wordIdAndLength));
            numResults += wordIdAndLength.length - 1;
        }
        if (numResults == 0) {
            return EMPTY_RESULT;
        }
        int[][] result = new int[numResults][];
        int index = 0;
        for (int i = 0; i < matches.size(); ++i) {
            Match match = (Match)matches.get(i);
            int[] wordIdAndLength = match.wordIdAndLength;
            int wordId = wordIdAndLength[0];
            int position = match.position;
            for (int j = 1; j < wordIdAndLength.length; ++j) {
                int[] token = new int[]{wordId + j - 1, position, wordIdAndLength[j]};
                result[index++] = token;
                position += wordIdAndLength[j];
            }
        }
        return result;
    }

    public TokenInfoFST getFST() {
        return this.fst;
    }

    public int[] lookupSegmentation(int phraseID) {
        return this.segmentations[phraseID];
    }

    @Override
    public int getLeftId(int wordId) {
        return 5;
    }

    @Override
    public int getRightId(int wordId) {
        return 5;
    }

    @Override
    public int getWordCost(int wordId) {
        return -100000;
    }

    @Override
    public String getReading(int wordId, char[] surface, int off, int len) {
        return this.getFeature(wordId, 0);
    }

    @Override
    public String getPartOfSpeech(int wordId) {
        return this.getFeature(wordId, 1);
    }

    @Override
    public String getBaseForm(int wordId, char[] surface, int off, int len) {
        return null;
    }

    @Override
    public String getPronunciation(int wordId, char[] surface, int off, int len) {
        return null;
    }

    @Override
    public String getInflectionType(int wordId) {
        return null;
    }

    @Override
    public String getInflectionForm(int wordId) {
        return null;
    }

    private String[] getAllFeaturesArray(int wordId) {
        String allFeatures = this.data[wordId - 100000000];
        if (allFeatures == null) {
            return null;
        }
        return allFeatures.split("\u0000");
    }

    private String getFeature(int wordId, int ... fields) {
        String[] allFeatures = this.getAllFeaturesArray(wordId);
        if (allFeatures == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        if (fields.length == 0) {
            for (String feature : allFeatures) {
                sb.append(CSVUtil.quoteEscape((String)feature)).append(",");
            }
        } else if (fields.length == 1) {
            sb.append(allFeatures[fields[0]]).append(",");
        } else {
            for (int field : fields) {
                sb.append(CSVUtil.quoteEscape((String)allFeatures[field])).append(",");
            }
        }
        return sb.deleteCharAt(sb.length() - 1).toString();
    }

    private static class Match {
        final int position;
        final int[] wordIdAndLength;

        Match(int position, int[] wordIdAndLength) {
            this.position = position;
            this.wordIdAndLength = wordIdAndLength;
        }
    }
}

