/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.namefind;

import opennlp.tools.namefind.NameSample;
import opennlp.tools.namefind.TokenNameFinder;
import opennlp.tools.namefind.TokenNameFinderEvaluationMonitor;
import opennlp.tools.util.Span;
import opennlp.tools.util.eval.Evaluator;
import opennlp.tools.util.eval.FMeasure;

public class TokenNameFinderEvaluator
extends Evaluator<NameSample> {
    private FMeasure fmeasure = new FMeasure();
    private TokenNameFinder nameFinder;

    public TokenNameFinderEvaluator(TokenNameFinder nameFinder, TokenNameFinderEvaluationMonitor ... listeners) {
        super(listeners);
        this.nameFinder = nameFinder;
    }

    @Override
    protected NameSample processSample(NameSample reference) {
        if (reference.isClearAdaptiveDataSet()) {
            this.nameFinder.clearAdaptiveData();
        }
        Object[] predictedNames = this.nameFinder.find(reference.getSentence());
        Object[] references = reference.getNames();
        for (int i = 0; i < references.length; ++i) {
            if (references[i].getType() != null) continue;
            references[i] = new Span(((Span)references[i]).getStart(), ((Span)references[i]).getEnd(), "default");
        }
        this.fmeasure.updateScores(references, predictedNames);
        return new NameSample(reference.getSentence(), (Span[])predictedNames, reference.isClearAdaptiveDataSet());
    }

    public FMeasure getFMeasure() {
        return this.fmeasure;
    }
}

