/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.luke.app.desktop;

import java.awt.GraphicsEnvironment;
import java.lang.invoke.MethodHandles;
import java.util.Arrays;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.apache.lucene.luke.app.desktop.MessageBroker;
import org.apache.lucene.luke.app.desktop.components.LukeWindowProvider;
import org.apache.lucene.luke.app.desktop.components.dialog.menubar.OpenIndexDialogFactory;
import org.apache.lucene.luke.app.desktop.util.DialogOpener;
import org.apache.lucene.luke.app.desktop.util.ExceptionHandler;
import org.apache.lucene.luke.app.desktop.util.FontUtils;
import org.apache.lucene.luke.app.desktop.util.MessageUtils;
import org.apache.lucene.luke.util.LoggerFactory;

public class LukeMain {
    private static final Logger log;
    private static JFrame frame;

    public static JFrame getOwnerFrame() {
        return frame;
    }

    private static boolean createGUI() {
        MessageBroker messageBroker = MessageBroker.getInstance();
        try {
            Thread.setDefaultUncaughtExceptionHandler((thread, cause) -> ExceptionHandler.handle(cause, messageBroker));
            frame = new LukeWindowProvider().get();
            frame.setLocation(200, 100);
            frame.setDefaultCloseOperation(3);
            frame.pack();
            frame.setVisible(true);
            return true;
        }
        catch (Throwable e) {
            messageBroker.showUnknownErrorMessage();
            log.log(Level.SEVERE, "Cannot initialize components.", e);
            return false;
        }
    }

    public static void main(String[] args) throws Exception {
        String lookAndFeelClassName;
        boolean sanityCheck = Arrays.asList(args).contains("--sanity-check");
        if (sanityCheck && GraphicsEnvironment.isHeadless()) {
            Logger.getGlobal().log(Level.SEVERE, "[Vader] Hello, Luke. Can't do much in headless mode.");
            Runtime.getRuntime().exit(0);
        }
        if (!(lookAndFeelClassName = UIManager.getSystemLookAndFeelClassName()).contains("AquaLookAndFeel") && !lookAndFeelClassName.contains("PlasticXPLookAndFeel")) {
            lookAndFeelClassName = "javax.swing.plaf.metal.MetalLookAndFeel";
        }
        UIManager.setLookAndFeel(lookAndFeelClassName);
        GraphicsEnvironment genv = GraphicsEnvironment.getLocalGraphicsEnvironment();
        genv.registerFont(FontUtils.createElegantIconFont());
        SynchronousQueue guiThreadResult = new SynchronousQueue();
        SwingUtilities.invokeLater(() -> {
            try {
                long _start = System.nanoTime();
                guiThreadResult.put(LukeMain.createGUI());
                OpenIndexDialogFactory openIndexDialogFactory = OpenIndexDialogFactory.getInstance();
                new DialogOpener<OpenIndexDialogFactory>(openIndexDialogFactory).open(MessageUtils.getLocalizedMessage("openindex.dialog.title"), 600, 420, factory -> {}, new String[0]);
                long _end = System.nanoTime() / 1000000L;
                log.info("Elapsed time for initializing GUI: " + TimeUnit.NANOSECONDS.toMillis(_end - _start) + " ms");
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
        if (Boolean.FALSE.equals(guiThreadResult.take())) {
            Logger.getGlobal().log(Level.SEVERE, "Luke could not start.");
            Runtime.getRuntime().exit(1);
        }
        if (sanityCheck) {
            Logger.getGlobal().log(Level.SEVERE, "[Vader] Hello, Luke. We seem to be fine.");
            Runtime.getRuntime().exit(0);
        }
    }

    static {
        LoggerFactory.initGuiLogging();
        log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    }
}

