/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.luke.app.desktop.components.fragments.search;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.luke.app.desktop.components.ComponentOperatorRegistry;
import org.apache.lucene.luke.app.desktop.components.TabSwitcherProxy;
import org.apache.lucene.luke.app.desktop.components.TabbedPaneProvider;
import org.apache.lucene.luke.app.desktop.components.TableColumnInfo;
import org.apache.lucene.luke.app.desktop.components.TableModelBase;
import org.apache.lucene.luke.app.desktop.components.fragments.search.FieldValuesPaneProvider;
import org.apache.lucene.luke.app.desktop.components.fragments.search.MLTTabOperator;
import org.apache.lucene.luke.app.desktop.util.FontUtils;
import org.apache.lucene.luke.app.desktop.util.MessageUtils;
import org.apache.lucene.luke.app.desktop.util.TableUtils;
import org.apache.lucene.luke.models.search.MLTConfig;

public final class MLTPaneProvider
implements MLTTabOperator {
    private final JLabel analyzerLbl = new JLabel(StandardAnalyzer.class.getName());
    private final JFormattedTextField maxDocFreqFTF = new JFormattedTextField();
    private final JFormattedTextField minDocFreqFTF = new JFormattedTextField();
    private final JFormattedTextField minTermFreqFTF = new JFormattedTextField();
    private final JCheckBox loadAllCB = new JCheckBox();
    private final JTable fieldsTable = new JTable();
    private final TabSwitcherProxy tabSwitcher;
    private final ListenerFunctions listeners = new ListenerFunctions();
    private MLTConfig config = new MLTConfig.Builder().build();

    public MLTPaneProvider() {
        this.tabSwitcher = TabSwitcherProxy.getInstance();
        ComponentOperatorRegistry.getInstance().register(MLTTabOperator.class, this);
    }

    public JScrollPane get() {
        JPanel panel = new JPanel();
        panel.setOpaque(false);
        panel.setLayout(new BoxLayout(panel, 3));
        panel.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        panel.add(this.initMltParamsPanel());
        panel.add(new JSeparator(0));
        panel.add(this.initAnalyzerNamePanel());
        panel.add(new JSeparator(0));
        panel.add(this.initFieldsSettingsPanel());
        JScrollPane scrollPane = new JScrollPane(panel);
        scrollPane.setOpaque(false);
        scrollPane.getViewport().setOpaque(false);
        return scrollPane;
    }

    private JPanel initMltParamsPanel() {
        JPanel panel = new JPanel(new GridLayout(3, 1));
        panel.setOpaque(false);
        JPanel maxDocFreq = new JPanel(new FlowLayout(3));
        maxDocFreq.setOpaque(false);
        maxDocFreq.add(new JLabel(MessageUtils.getLocalizedMessage("search_mlt.label.max_doc_freq")));
        this.maxDocFreqFTF.setColumns(10);
        this.maxDocFreqFTF.setValue(this.config.getMaxDocFreq());
        maxDocFreq.add(this.maxDocFreqFTF);
        maxDocFreq.add(new JLabel(MessageUtils.getLocalizedMessage("label.int_required")));
        panel.add(maxDocFreq);
        JPanel minDocFreq = new JPanel(new FlowLayout(3));
        minDocFreq.setOpaque(false);
        minDocFreq.add(new JLabel(MessageUtils.getLocalizedMessage("search_mlt.label.min_doc_freq")));
        this.minDocFreqFTF.setColumns(5);
        this.minDocFreqFTF.setValue(this.config.getMinDocFreq());
        minDocFreq.add(this.minDocFreqFTF);
        minDocFreq.add(new JLabel(MessageUtils.getLocalizedMessage("label.int_required")));
        panel.add(minDocFreq);
        JPanel minTermFreq = new JPanel(new FlowLayout(3));
        minTermFreq.setOpaque(false);
        minTermFreq.add(new JLabel(MessageUtils.getLocalizedMessage("serach_mlt.label.min_term_freq")));
        this.minTermFreqFTF.setColumns(5);
        this.minTermFreqFTF.setValue(this.config.getMinTermFreq());
        minTermFreq.add(this.minTermFreqFTF);
        minTermFreq.add(new JLabel(MessageUtils.getLocalizedMessage("label.int_required")));
        panel.add(minTermFreq);
        return panel;
    }

    private JPanel initAnalyzerNamePanel() {
        JPanel panel = new JPanel(new FlowLayout(3));
        panel.setOpaque(false);
        panel.add(new JLabel(MessageUtils.getLocalizedMessage("search_mlt.label.analyzer")));
        panel.add(this.analyzerLbl);
        JLabel changeLbl = new JLabel(MessageUtils.getLocalizedMessage("search_mlt.hyperlink.change"));
        changeLbl.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                MLTPaneProvider.this.tabSwitcher.switchTab(TabbedPaneProvider.Tab.ANALYZER);
            }
        });
        panel.add(FontUtils.toLinkText(changeLbl));
        return panel;
    }

    private JPanel initFieldsSettingsPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.setOpaque(false);
        panel.setPreferredSize(new Dimension(500, 300));
        panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        JPanel header = new JPanel(new GridLayout(2, 1));
        header.setOpaque(false);
        header.setBorder(BorderFactory.createEmptyBorder(0, 0, 10, 0));
        header.add(new JLabel(MessageUtils.getLocalizedMessage("search_mlt.label.description")));
        this.loadAllCB.setText(MessageUtils.getLocalizedMessage("search_mlt.checkbox.select_all"));
        this.loadAllCB.setSelected(true);
        this.loadAllCB.addActionListener(this.listeners::loadAllFields);
        this.loadAllCB.setOpaque(false);
        header.add(this.loadAllCB);
        panel.add((Component)header, "First");
        TableUtils.setupTable(this.fieldsTable, 0, new MLTFieldsTableModel(), null, MLTFieldsTableModel.Column.SELECT.getColumnWidth());
        this.fieldsTable.setPreferredScrollableViewportSize(this.fieldsTable.getPreferredSize());
        panel.add((Component)new JScrollPane(this.fieldsTable), "Center");
        return panel;
    }

    @Override
    public void setAnalyzer(Analyzer analyzer) {
        this.analyzerLbl.setText(analyzer.getClass().getName());
    }

    @Override
    public void setFields(Collection<String> fields) {
        this.fieldsTable.setModel(new MLTFieldsTableModel(fields));
        this.fieldsTable.getColumnModel().getColumn(MLTFieldsTableModel.Column.SELECT.getIndex()).setMinWidth(MLTFieldsTableModel.Column.SELECT.getColumnWidth());
        this.fieldsTable.getColumnModel().getColumn(MLTFieldsTableModel.Column.SELECT.getIndex()).setMaxWidth(MLTFieldsTableModel.Column.SELECT.getColumnWidth());
        this.fieldsTable.getModel().addTableModelListener(this.listeners::tableDataChenged);
    }

    @Override
    public MLTConfig getConfig() {
        ArrayList<String> fields = new ArrayList<String>();
        for (int row = 0; row < this.fieldsTable.getRowCount(); ++row) {
            boolean selected = (Boolean)this.fieldsTable.getValueAt(row, MLTFieldsTableModel.Column.SELECT.getIndex());
            if (!selected) continue;
            fields.add((String)this.fieldsTable.getValueAt(row, MLTFieldsTableModel.Column.FIELD.getIndex()));
        }
        return new MLTConfig.Builder().fields(fields).maxDocFreq((Integer)this.maxDocFreqFTF.getValue()).minDocFreq((Integer)this.minDocFreqFTF.getValue()).minTermFreq((Integer)this.minTermFreqFTF.getValue()).build();
    }

    static final class MLTFieldsTableModel
    extends TableModelBase<Column> {
        MLTFieldsTableModel() {
        }

        MLTFieldsTableModel(Collection<String> fields) {
            super(fields.size());
            int i = 0;
            for (String field : fields) {
                this.data[i][Column.SELECT.getIndex()] = true;
                this.data[i][Column.FIELD.getIndex()] = field;
                ++i;
            }
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == Column.SELECT.getIndex();
        }

        @Override
        public void setValueAt(Object value, int rowIndex, int columnIndex) {
            this.data[rowIndex][columnIndex] = value;
            this.fireTableCellUpdated(rowIndex, columnIndex);
        }

        protected Column[] columnInfos() {
            return Column.values();
        }

        static enum Column implements TableColumnInfo
        {
            SELECT("Select", 0, Boolean.class, 50),
            FIELD("Field", 1, String.class, Integer.MAX_VALUE);

            private final String colName;
            private final int index;
            private final Class<?> type;
            private final int width;

            private Column(String colName, int index, Class<?> type, int width) {
                this.colName = colName;
                this.index = index;
                this.type = type;
                this.width = width;
            }

            @Override
            public String getColName() {
                return this.colName;
            }

            @Override
            public int getIndex() {
                return this.index;
            }

            @Override
            public Class<?> getType() {
                return this.type;
            }

            @Override
            public int getColumnWidth() {
                return this.width;
            }
        }
    }

    private class ListenerFunctions {
        private ListenerFunctions() {
        }

        void loadAllFields(ActionEvent e) {
            for (int i = 0; i < MLTPaneProvider.this.fieldsTable.getModel().getRowCount(); ++i) {
                if (MLTPaneProvider.this.loadAllCB.isSelected()) {
                    MLTPaneProvider.this.fieldsTable.setValueAt(true, i, FieldValuesPaneProvider.FieldsTableModel.Column.LOAD.getIndex());
                    continue;
                }
                MLTPaneProvider.this.fieldsTable.setValueAt(false, i, FieldValuesPaneProvider.FieldsTableModel.Column.LOAD.getIndex());
            }
        }

        void tableDataChenged(TableModelEvent e) {
            boolean isLoad;
            int row = e.getFirstRow();
            int col = e.getColumn();
            if (col == MLTFieldsTableModel.Column.SELECT.getIndex() && !(isLoad = ((Boolean)MLTPaneProvider.this.fieldsTable.getModel().getValueAt(row, col)).booleanValue())) {
                MLTPaneProvider.this.loadAllCB.setSelected(false);
            }
        }
    }
}

