/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.luke.models.overview;

import java.io.IOException;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.luke.models.LukeException;
import org.apache.lucene.luke.models.LukeModel;
import org.apache.lucene.luke.models.overview.Overview;
import org.apache.lucene.luke.models.overview.TermCounts;
import org.apache.lucene.luke.models.overview.TermCountsOrder;
import org.apache.lucene.luke.models.overview.TermStats;
import org.apache.lucene.luke.models.overview.TopTerms;
import org.apache.lucene.luke.models.util.IndexUtils;

public final class OverviewImpl
extends LukeModel
implements Overview {
    private final String indexPath;
    private final TermCounts termCounts;
    private final TopTerms topTerms;

    public OverviewImpl(IndexReader reader, String indexPath) {
        super(reader);
        this.indexPath = Objects.requireNonNull(indexPath);
        try {
            this.termCounts = new TermCounts(reader);
        }
        catch (IOException e) {
            throw new LukeException("An error occurred when collecting term statistics.", e);
        }
        this.topTerms = new TopTerms(reader);
    }

    @Override
    public String getIndexPath() {
        return this.indexPath;
    }

    @Override
    public int getNumFields() {
        return IndexUtils.getFieldInfos(this.reader).size();
    }

    @Override
    public int getNumDocuments() {
        return this.reader.numDocs();
    }

    @Override
    public long getNumTerms() {
        return this.termCounts.numTerms();
    }

    @Override
    public boolean hasDeletions() {
        return this.reader.hasDeletions();
    }

    @Override
    public int getNumDeletedDocs() {
        return this.reader.numDeletedDocs();
    }

    @Override
    public Optional<Boolean> isOptimized() {
        if (this.commit != null) {
            return Optional.of(this.commit.getSegmentCount() == 1);
        }
        return Optional.empty();
    }

    @Override
    public Optional<Long> getIndexVersion() {
        if (this.reader instanceof DirectoryReader) {
            return Optional.of(((DirectoryReader)this.reader).getVersion());
        }
        return Optional.empty();
    }

    @Override
    public Optional<String> getIndexFormat() {
        if (this.dir == null) {
            return Optional.empty();
        }
        try {
            return Optional.of(IndexUtils.getIndexFormat(this.dir));
        }
        catch (IOException e) {
            throw new LukeException("Index format not available.", e);
        }
    }

    @Override
    public Optional<String> getDirImpl() {
        if (this.dir == null) {
            return Optional.empty();
        }
        return Optional.of(this.dir.getClass().getName());
    }

    @Override
    public Optional<String> getCommitDescription() {
        if (this.commit == null) {
            return Optional.empty();
        }
        return Optional.of(this.commit.getSegmentsFileName() + " (generation=" + this.commit.getGeneration() + ", segs=" + this.commit.getSegmentCount() + ")");
    }

    @Override
    public Optional<String> getCommitUserData() {
        if (this.commit == null) {
            return Optional.empty();
        }
        try {
            return Optional.of(IndexUtils.getCommitUserData(this.commit));
        }
        catch (IOException e) {
            throw new LukeException("Commit user data not available.", e);
        }
    }

    @Override
    public Map<String, Long> getSortedTermCounts(TermCountsOrder order) {
        if (order == null) {
            order = TermCountsOrder.COUNT_DESC;
        }
        return this.termCounts.sortedTermCounts(order);
    }

    @Override
    public List<TermStats> getTopTerms(String field, int numTerms) {
        Objects.requireNonNull(field);
        if (numTerms < 0) {
            throw new IllegalArgumentException(String.format(Locale.ENGLISH, "'numTerms' must be a positive integer: %d is not accepted.", numTerms));
        }
        try {
            return this.topTerms.getTopTerms(field, numTerms);
        }
        catch (Exception e) {
            throw new LukeException(String.format(Locale.ENGLISH, "Top terms for field %s not available.", field), e);
        }
    }
}

