/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.luke.models.overview;

import java.io.IOException;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.luke.models.overview.TermCountsOrder;
import org.apache.lucene.luke.models.util.IndexUtils;

final class TermCounts {
    private final Map<String, Long> termCountMap;

    TermCounts(IndexReader reader) throws IOException {
        Objects.requireNonNull(reader);
        this.termCountMap = IndexUtils.countTerms(reader, IndexUtils.getFieldNames(reader));
    }

    long numTerms() {
        return this.termCountMap.values().stream().mapToLong(Long::longValue).sum();
    }

    Map<String, Long> sortedTermCounts(TermCountsOrder order) {
        Comparator<Map.Entry<String, Long>> comparator;
        Objects.requireNonNull(order);
        switch (order) {
            case NAME_ASC: {
                comparator = Map.Entry.comparingByKey();
                break;
            }
            case NAME_DESC: {
                comparator = Map.Entry.comparingByKey().reversed();
                break;
            }
            case COUNT_ASC: {
                comparator = Map.Entry.comparingByValue();
                break;
            }
            case COUNT_DESC: {
                comparator = Map.Entry.comparingByValue().reversed();
                break;
            }
            default: {
                comparator = Map.Entry.comparingByKey();
            }
        }
        return this.sortedTermCounts(comparator);
    }

    private Map<String, Long> sortedTermCounts(Comparator<Map.Entry<String, Long>> comparator) {
        return this.termCountMap.entrySet().stream().sorted(comparator).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (v1, v2) -> v1, LinkedHashMap::new));
    }
}

