/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.ko.util;

import java.io.IOException;
import java.nio.file.Path;
import org.apache.lucene.analysis.ko.dict.CharacterDefinition;
import org.apache.lucene.analysis.ko.dict.UnknownDictionary;
import org.apache.lucene.analysis.ko.util.BinaryDictionaryWriter;
import org.apache.lucene.analysis.ko.util.CharacterDefinitionWriter;

class UnknownDictionaryWriter
extends BinaryDictionaryWriter {
    private final CharacterDefinitionWriter characterDefinition = new CharacterDefinitionWriter();

    public UnknownDictionaryWriter(int size) {
        super(UnknownDictionary.class, size);
    }

    @Override
    public int put(String[] entry) {
        int wordId = this.buffer.position();
        int result = super.put(entry);
        byte characterId = CharacterDefinition.lookupCharacterClass(entry[0]);
        this.addMapping(characterId, wordId);
        return result;
    }

    public void putCharacterCategory(int codePoint, String characterClassName) {
        this.characterDefinition.putCharacterCategory(codePoint, characterClassName);
    }

    public void putInvokeDefinition(String characterClassName, int invoke, int group, int length) {
        this.characterDefinition.putInvokeDefinition(characterClassName, invoke, group, length);
    }

    @Override
    public void write(Path baseDir) throws IOException {
        super.write(baseDir);
        this.characterDefinition.write(baseDir);
    }
}

