/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.api;

import java.util.Collection;
import java.util.List;
import java.util.stream.Stream;
import org.apache.maven.api.ExtensibleEnum;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Immutable;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.model.Plugin;

@Experimental
@Immutable
public interface Lifecycle
extends ExtensibleEnum {
    public static final String CLEAN = "clean";
    public static final String DEFAULT = "default";
    public static final String SITE = "site";
    public static final String BEFORE = "before:";
    public static final String AFTER = "after:";
    public static final String AT = "at:";

    @Override
    public String id();

    public Collection<Phase> phases();

    default public Collection<Phase> v3phases() {
        return this.phases();
    }

    default public Stream<Phase> allPhases() {
        return this.phases().stream().flatMap(Phase::allPhases);
    }

    public Collection<Alias> aliases();

    public static interface ChildrenPointer
    extends Pointer {
        @Override
        default public Pointer.Type type() {
            return Pointer.Type.CHILDREN;
        }
    }

    public static interface DependenciesPointer
    extends Pointer {
        public String scope();

        @Override
        default public Pointer.Type type() {
            return Pointer.Type.DEPENDENCIES;
        }
    }

    public static interface PhasePointer
    extends Pointer {
        @Override
        default public Pointer.Type type() {
            return Pointer.Type.PROJECT;
        }
    }

    public static interface Pointer {
        public String phase();

        public Type type();

        public static enum Type {
            PROJECT,
            DEPENDENCIES,
            CHILDREN;

        }
    }

    public static interface Link {
        public Kind kind();

        public Pointer pointer();

        public static enum Kind {
            BEFORE,
            AFTER;

        }
    }

    public static interface Alias {
        public String v3Phase();

        public String v4Phase();
    }

    public static interface Phase {
        public static final String ALL = "all";
        public static final String BUILD = "build";
        public static final String INITIALIZE = "initialize";
        public static final String VALIDATE = "validate";
        public static final String SOURCES = "sources";
        public static final String RESOURCES = "resources";
        public static final String COMPILE = "compile";
        public static final String READY = "ready";
        public static final String PACKAGE = "package";
        public static final String VERIFY = "verify";
        public static final String UNIT_TEST = "unit-test";
        public static final String TEST_SOURCES = "test-sources";
        public static final String TEST_RESOURCES = "test-resources";
        public static final String TEST_COMPILE = "test-compile";
        public static final String TEST = "test";
        public static final String INTEGRATION_TEST = "integration-test";
        public static final String INSTALL = "install";
        public static final String DEPLOY = "deploy";
        public static final String CLEAN = "clean";

        @Nonnull
        public String name();

        @Nonnull
        public List<Plugin> plugins();

        @Nonnull
        public Collection<Link> links();

        @Nonnull
        public List<Phase> phases();

        @Nonnull
        public Stream<Phase> allPhases();
    }
}

