/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.nar;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.apache.nifi.bundle.Bundle;
import org.apache.nifi.bundle.BundleCoordinate;
import org.apache.nifi.bundle.BundleDetails;
import org.apache.nifi.nar.ExtensionDiscoveringManager;
import org.apache.nifi.nar.ExtensionMapping;
import org.apache.nifi.nar.ExtensionUiLoader;
import org.apache.nifi.nar.NarClassLoaders;
import org.apache.nifi.nar.NarLoadResult;
import org.apache.nifi.nar.NarLoader;
import org.apache.nifi.nar.NarManifestEntry;
import org.apache.nifi.nar.NarUnpackMode;
import org.apache.nifi.nar.NarUnpacker;
import org.apache.nifi.nar.PythonBundle;
import org.apache.nifi.util.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandardNarLoader
implements NarLoader {
    private static final Logger LOGGER = LoggerFactory.getLogger(StandardNarLoader.class);
    private final File extensionsWorkingDir;
    private final NarClassLoaders narClassLoaders;
    private final ExtensionDiscoveringManager extensionManager;
    private final ExtensionMapping extensionMapping;
    private final ExtensionUiLoader extensionUiLoader;
    private final NarUnpackMode narUnpackMode;
    private Set<BundleDetails> previouslySkippedBundles;

    public StandardNarLoader(File extensionsWorkingDir, NarClassLoaders narClassLoaders, ExtensionDiscoveringManager extensionManager, ExtensionMapping extensionMapping, ExtensionUiLoader extensionUiLoader, NarUnpackMode narUnpackMode) {
        this.extensionsWorkingDir = extensionsWorkingDir;
        this.narClassLoaders = narClassLoaders;
        this.extensionManager = extensionManager;
        this.extensionMapping = extensionMapping;
        this.extensionUiLoader = extensionUiLoader;
        this.narUnpackMode = narUnpackMode;
    }

    @Override
    public NarLoadResult load(Collection<File> narFiles) {
        return this.load(narFiles, null);
    }

    @Override
    public synchronized NarLoadResult load(Collection<File> narFiles, Set<Class<?>> extensionTypes) {
        LOGGER.info("Loading NAR Files [{}]", (Object)narFiles.size());
        ArrayList<File> unpackedNars = new ArrayList<File>();
        for (File narFile : narFiles) {
            LOGGER.debug("Unpacking NAR File [{}] started", (Object)narFile.getName());
            File unpackedNar = this.unpack(narFile);
            if (unpackedNar == null) continue;
            LOGGER.debug("Unpacking NAR File [{}] completed", (Object)narFile.getName());
            unpackedNars.add(unpackedNar);
        }
        if (this.previouslySkippedBundles != null && !this.previouslySkippedBundles.isEmpty()) {
            LOGGER.info("Including [{}] previously skipped bundles", (Object)this.previouslySkippedBundles.size());
            this.previouslySkippedBundles.forEach(b -> unpackedNars.add(b.getWorkingDirectory()));
        }
        if (unpackedNars.isEmpty()) {
            return new NarLoadResult(Collections.emptySet(), Collections.emptySet());
        }
        NarLoadResult narLoadResult = this.narClassLoaders.loadAdditionalNars(unpackedNars);
        Set loadedBundles = narLoadResult.getLoadedBundles();
        Set skippedBundles = narLoadResult.getSkippedBundles();
        LOGGER.info("Created class loaders for [{}] NAR bundles with [{}] skipped", (Object)loadedBundles.size(), (Object)skippedBundles.size());
        this.previouslySkippedBundles = new HashSet<BundleDetails>(skippedBundles);
        if (!loadedBundles.isEmpty()) {
            if (extensionTypes == null) {
                this.extensionManager.discoverExtensions(loadedBundles);
                this.discoverPythonExtensions(loadedBundles);
            } else {
                this.extensionManager.discoverExtensions(loadedBundles, extensionTypes, true);
                this.discoverPythonExtensions(loadedBundles);
            }
            if (this.extensionUiLoader != null) {
                LOGGER.debug("Loading custom UI extensions");
                this.extensionUiLoader.loadExtensionUis(loadedBundles);
            }
        }
        return narLoadResult;
    }

    @Override
    public synchronized void unload(Collection<Bundle> bundles) {
        if (this.extensionUiLoader != null) {
            this.extensionUiLoader.unloadExtensionUis(bundles);
        }
        List<BundleCoordinate> bundleCoordinates = bundles.stream().map(Bundle::getBundleDetails).map(BundleDetails::getCoordinate).toList();
        for (BundleCoordinate bundleCoordinate : bundleCoordinates) {
            LOGGER.info("Unloading bundle [{}]", (Object)bundleCoordinate);
        }
        Set removedBundles = this.extensionManager.removeBundles(bundleCoordinates);
        removedBundles.forEach(this::removeBundle);
    }

    private void removeBundle(Bundle bundle) {
        this.narClassLoaders.removeBundle(bundle);
        File workingDirectory = bundle.getBundleDetails().getWorkingDirectory();
        if (workingDirectory.exists()) {
            LOGGER.debug("Removing NAR working directory [{}]", (Object)workingDirectory.getAbsolutePath());
            try {
                FileUtils.deleteFile((File)workingDirectory, (boolean)true);
            }
            catch (IOException e) {
                LOGGER.warn("Failed to delete bundle working directory [{}]", (Object)workingDirectory.getAbsolutePath());
            }
        } else {
            LOGGER.debug("NAR working directory does not exist at [{}]", (Object)workingDirectory.getAbsolutePath());
        }
    }

    private void discoverPythonExtensions(Set<Bundle> loadedBundles) {
        Bundle pythonBundle = this.extensionManager.getBundle(PythonBundle.PYTHON_BUNDLE_COORDINATE);
        if (pythonBundle == null) {
            LOGGER.warn("Python Bundle does not exist in the ExtensionManager, will not discover new Python extensions");
        } else {
            this.extensionManager.discoverPythonExtensions(pythonBundle, loadedBundles);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private File unpack(File narFile) {
        try (JarFile nar = new JarFile(narFile);){
            Manifest manifest = nar.getManifest();
            Attributes attributes = manifest.getMainAttributes();
            String groupId = attributes.getValue(NarManifestEntry.NAR_GROUP.getEntryName());
            String narId = attributes.getValue(NarManifestEntry.NAR_ID.getEntryName());
            String version = attributes.getValue(NarManifestEntry.NAR_VERSION.getEntryName());
            if ("nifi-framework-nar".equals(narId)) {
                LOGGER.error("Found a framework NAR, will not auto-load {}", (Object)narFile.getAbsolutePath());
                File file = null;
                return file;
            }
            if ("nifi-jetty-nar".equals(narId)) {
                LOGGER.error("Found a Jetty NAR, will not auto-load {}", (Object)narFile.getAbsolutePath());
                File file = null;
                return file;
            }
            BundleCoordinate coordinate = new BundleCoordinate(groupId, narId, version);
            Bundle bundle = this.extensionManager.getBundle(coordinate);
            if (bundle != null) {
                LOGGER.warn("Found existing bundle with coordinate {}, will not load {}", (Object)coordinate, (Object)narFile.getAbsolutePath());
                File file = null;
                return file;
            }
            File unpackedExtension = NarUnpacker.unpackNar((File)narFile, (File)this.extensionsWorkingDir, (boolean)true, (NarUnpackMode)this.narUnpackMode);
            NarUnpacker.mapExtension((File)unpackedExtension, (BundleCoordinate)coordinate, (ExtensionMapping)this.extensionMapping);
            File file = unpackedExtension;
            return file;
        }
        catch (Exception e) {
            LOGGER.error("Error unpacking {}", (Object)narFile.getAbsolutePath(), (Object)e);
            return null;
        }
    }
}

