/*
 * Decompiled with CFR 0.152.
 */
package org.archive.format.gzip.zipnum;

import org.apache.commons.lang3.math.NumberUtils;
import org.archive.format.gzip.zipnum.TimestampDedupIterator;
import org.archive.util.iterator.CloseableIterator;

public class TimestampBestPickDedupIterator
extends TimestampDedupIterator {
    private int additionalFieldNum = 3;
    private int sep = 32;

    public TimestampBestPickDedupIterator(CloseableIterator<String> inner, int timestampDedupLength) {
        super(inner, timestampDedupLength);
    }

    @Override
    public String getNextInner() {
        if (this.isFirst) {
            if (this.inner.hasNext()) {
                this.nextLine = (String)this.inner.next();
                this.nextStamp = this.extractMatchKey(this.nextLine);
            }
            this.isFirst = false;
        }
        String currLine = null;
        String currStamp = null;
        boolean same = false;
        do {
            if (!same || this.pickNew(currStamp, this.nextStamp, currLine, this.nextLine)) {
                currLine = this.nextLine;
                currStamp = this.nextStamp;
            }
            this.nextLine = this.inner.hasNext() ? (String)this.inner.next() : null;
            this.nextStamp = this.extractMatchKey(this.nextLine);
        } while (this.nextLine != null && (same = this.isSame(currStamp, this.nextStamp, currLine, this.nextLine)));
        return currLine;
    }

    protected boolean pickNew(String currStamp, String nextStamp, String currLine, String nextLine) {
        String currStatusStr = this.getNthField(currLine, currStamp.length(), this.additionalFieldNum, this.sep);
        String nextStatusStr = this.getNthField(nextLine, nextStamp.length(), this.additionalFieldNum, this.sep);
        int currStatusNum = NumberUtils.toInt((String)currStatusStr, (int)Integer.MAX_VALUE);
        int nextStatusNum = NumberUtils.toInt((String)nextStatusStr, (int)Integer.MAX_VALUE);
        return nextStatusNum <= currStatusNum;
    }
}

