/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit;

import com.gargoylesoftware.htmlunit.HttpMethod;
import com.gargoylesoftware.htmlunit.WebRequest;
import com.gargoylesoftware.htmlunit.WebResponse;
import com.gargoylesoftware.htmlunit.WebResponseData;
import com.gargoylesoftware.htmlunit.util.NameValuePair;
import com.gargoylesoftware.htmlunit.util.StringUtils;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;

public class StringWebResponse
extends WebResponse {
    private boolean fromJavascript_;

    public StringWebResponse(String content, URL originatingURL) {
        this(content, StandardCharsets.UTF_8, originatingURL);
    }

    public StringWebResponse(String content, Charset charset, URL originatingURL) {
        super(StringWebResponse.getWebResponseData(content, charset), StringWebResponse.buildWebRequest(originatingURL, charset), 0L);
    }

    private static WebResponseData getWebResponseData(String contentString, Charset charset) {
        byte[] content = StringUtils.toByteArray(contentString, charset);
        ArrayList<NameValuePair> compiledHeaders = new ArrayList<NameValuePair>();
        compiledHeaders.add(new NameValuePair("Content-Type", "text/html; charset=" + charset));
        return new WebResponseData(content, 200, "OK", compiledHeaders);
    }

    private static WebRequest buildWebRequest(URL originatingURL, Charset charset) {
        WebRequest webRequest = new WebRequest(originatingURL, HttpMethod.GET);
        webRequest.setCharset(charset);
        return webRequest;
    }

    public boolean isFromJavascript() {
        return this.fromJavascript_;
    }

    public void setFromJavascript(boolean fromJavascript) {
        this.fromJavascript_ = fromJavascript;
    }
}

