/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.metrics;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.EnumMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.mapreduce.Counter;
import org.apache.hadoop.mapreduce.TaskInputOutputContext;

public class ErrorTracker {
    private final String group;
    private final Map<ErrorType, AtomicLong> counts;
    private final AtomicLong totalCount;
    private Counter cachedTotalCounter;
    private final Map<ErrorType, Counter> cachedCounters;

    public ErrorTracker(String group) {
        this.group = group;
        this.counts = new EnumMap<ErrorType, AtomicLong>(ErrorType.class);
        this.cachedCounters = new EnumMap<ErrorType, Counter>(ErrorType.class);
        this.totalCount = new AtomicLong(0L);
        for (ErrorType type : ErrorType.values()) {
            this.counts.put(type, new AtomicLong(0L));
        }
    }

    public ErrorTracker(String group, TaskInputOutputContext<?, ?, ?, ?> context) {
        this(group);
        this.initCounters(context);
    }

    public void initCounters(TaskInputOutputContext<?, ?, ?, ?> context) {
        this.cachedTotalCounter = context.getCounter(this.group, "errors_total");
        for (ErrorType type : ErrorType.values()) {
            this.cachedCounters.put(type, context.getCounter(this.group, ErrorTracker.getCounterName(type)));
        }
    }

    public void recordError(Throwable t) {
        this.recordError(ErrorTracker.categorize(t));
    }

    public void recordError(ErrorType type) {
        this.counts.get((Object)type).incrementAndGet();
        this.totalCount.incrementAndGet();
    }

    public long getCount(ErrorType type) {
        return this.counts.get((Object)type).get();
    }

    public long getTotalCount() {
        return this.totalCount.get();
    }

    public void emitCounters(TaskInputOutputContext<?, ?, ?, ?> context) {
        if (this.cachedTotalCounter != null) {
            this.cachedTotalCounter.increment(this.totalCount.get());
            for (ErrorType type : ErrorType.values()) {
                long count = this.counts.get((Object)type).get();
                if (count <= 0L) continue;
                this.cachedCounters.get((Object)type).increment(count);
            }
        } else {
            context.getCounter(this.group, "errors_total").increment(this.totalCount.get());
            for (ErrorType type : ErrorType.values()) {
                long count = this.counts.get((Object)type).get();
                if (count <= 0L) continue;
                context.getCounter(this.group, ErrorTracker.getCounterName(type)).increment(count);
            }
        }
    }

    public void incrementCounters(Throwable t) {
        this.incrementCounters(ErrorTracker.categorize(t));
    }

    public void incrementCounters(ErrorType type) {
        if (this.cachedTotalCounter == null) {
            throw new IllegalStateException("Counters not initialized. Call initCounters() first.");
        }
        this.cachedTotalCounter.increment(1L);
        this.cachedCounters.get((Object)type).increment(1L);
    }

    public static ErrorType categorize(Throwable t) {
        ErrorType causeType;
        if (t == null) {
            return ErrorType.OTHER;
        }
        String className = t.getClass().getName();
        if (t instanceof SocketTimeoutException || className.contains("TimeoutException") || className.contains("Timeout")) {
            return ErrorType.TIMEOUT;
        }
        if (t instanceof SocketException || t instanceof UnknownHostException || className.contains("ConnectException") || className.contains("NoRouteToHostException") || className.contains("ConnectionRefusedException")) {
            return ErrorType.NETWORK;
        }
        if (t instanceof MalformedURLException || className.contains("URLFilterException") || className.contains("URISyntaxException")) {
            return ErrorType.URL;
        }
        if (t instanceof IOException) {
            return ErrorType.NETWORK;
        }
        if (className.contains("ProtocolException") || className.contains("ProtocolNotFound")) {
            return ErrorType.PROTOCOL;
        }
        if (className.contains("ParseException") || className.contains("ParserNotFound") || className.contains("SAXException") || className.contains("ParserConfigurationException")) {
            return ErrorType.PARSING;
        }
        if (className.contains("ScoringFilterException")) {
            return ErrorType.SCORING;
        }
        if (className.contains("IndexingException")) {
            return ErrorType.INDEXING;
        }
        Throwable cause = t.getCause();
        if (cause != null && cause != t && (causeType = ErrorTracker.categorize(cause)) != ErrorType.OTHER) {
            return causeType;
        }
        return ErrorType.OTHER;
    }

    public static String getCounterName(ErrorType type) {
        switch (type) {
            case NETWORK: {
                return "errors_network_total";
            }
            case PROTOCOL: {
                return "errors_protocol_total";
            }
            case PARSING: {
                return "errors_parsing_total";
            }
            case URL: {
                return "errors_url_total";
            }
            case SCORING: {
                return "errors_scoring_total";
            }
            case INDEXING: {
                return "errors_indexing_total";
            }
            case TIMEOUT: {
                return "errors_timeout_total";
            }
        }
        return "errors_other_total";
    }

    public static String getCounterName(Throwable t) {
        return ErrorTracker.getCounterName(ErrorTracker.categorize(t));
    }

    public static enum ErrorType {
        NETWORK,
        PROTOCOL,
        PARSING,
        URL,
        SCORING,
        INDEXING,
        TIMEOUT,
        OTHER;

    }
}

