/*
 * Decompiled with CFR 0.152.
 */
package org.weakref.jmx.guice;

import com.google.inject.multibindings.Multibinder;
import java.util.function.BiFunction;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.weakref.jmx.ObjectNameGenerator;
import org.weakref.jmx.guice.NamingFunction;
import org.weakref.jmx.guice.ObjectNameFunction;
import org.weakref.jmx.guice.SetMapping;

public class SetExportBinder<T> {
    private final Multibinder<SetMapping<?>> binder;
    private final Class<T> clazz;

    SetExportBinder(Multibinder<SetMapping<?>> binder, Class<T> clazz) {
        this.binder = binder;
        this.clazz = clazz;
    }

    public void withGeneratedName(NamingFunction<T> itemNamingFunction) {
        BiFunction<ObjectNameGenerator, Object, ObjectName> nameFactory = (factory, object) -> {
            try {
                String itemName = itemNamingFunction.name(object);
                return new ObjectName(factory.generatedNameOf(this.clazz, itemName));
            }
            catch (MalformedObjectNameException e) {
                throw new RuntimeException(e);
            }
        };
        this.as(nameFactory);
    }

    public void withGeneratedName(ObjectNameFunction<T> itemNamingFunction) {
        this.as((factory, object) -> itemNamingFunction.name(object));
    }

    public void as(BiFunction<ObjectNameGenerator, T, ObjectName> nameFactory) {
        this.binder.addBinding().toInstance(new SetMapping<T>(this.clazz, nameFactory));
    }
}

