/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution;

import io.trino.sql.tree.DefaultTraversalVisitor;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.Parameter;
import io.trino.sql.tree.Statement;
import java.util.ArrayList;
import java.util.List;

public final class ParameterExtractor {
    private ParameterExtractor() {
    }

    public static int getParameterCount(Statement statement) {
        return ParameterExtractor.getParameters(statement).size();
    }

    public static List<Parameter> getParameters(Statement statement) {
        ParameterExtractingVisitor parameterExtractingVisitor = new ParameterExtractingVisitor();
        parameterExtractingVisitor.process((Node)statement, null);
        return parameterExtractingVisitor.getParameters();
    }

    private static class ParameterExtractingVisitor
    extends DefaultTraversalVisitor<Void> {
        private final List<Parameter> parameters = new ArrayList<Parameter>();

        private ParameterExtractingVisitor() {
        }

        public List<Parameter> getParameters() {
            return this.parameters;
        }

        public Void visitParameter(Parameter node, Void context) {
            this.parameters.add(node);
            return null;
        }
    }
}

