/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.ImmutableList;
import io.trino.array.LongBigArray;
import io.trino.operator.GroupByHash;
import io.trino.operator.GroupByIdBlock;
import io.trino.operator.GroupedTopNBuilder;
import io.trino.operator.GroupedTopNRowNumberAccumulator;
import io.trino.operator.PageWithPositionComparator;
import io.trino.operator.RowReferencePageManager;
import io.trino.operator.TransformWork;
import io.trino.operator.Work;
import io.trino.spi.Page;
import io.trino.spi.PageBuilder;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.openjdk.jol.info.ClassLayout;

public class GroupedTopNRowNumberBuilder
implements GroupedTopNBuilder {
    private static final long INSTANCE_SIZE = ClassLayout.parseClass(GroupedTopNRowNumberBuilder.class).instanceSize();
    private final List<Type> sourceTypes;
    private final boolean produceRowNumber;
    private final GroupByHash groupByHash;
    private final RowReferencePageManager pageManager = new RowReferencePageManager();
    private final GroupedTopNRowNumberAccumulator groupedTopNRowNumberAccumulator;

    public GroupedTopNRowNumberBuilder(List<Type> sourceTypes, PageWithPositionComparator comparator, int topN, boolean produceRowNumber, GroupByHash groupByHash) {
        this.sourceTypes = Objects.requireNonNull(sourceTypes, "sourceTypes is null");
        Preconditions.checkArgument((topN > 0 ? 1 : 0) != 0, (Object)"topN must be > 0");
        this.produceRowNumber = produceRowNumber;
        this.groupByHash = Objects.requireNonNull(groupByHash, "groupByHash is null");
        Objects.requireNonNull(comparator, "comparator is null");
        this.groupedTopNRowNumberAccumulator = new GroupedTopNRowNumberAccumulator((leftRowId, rightRowId) -> {
            Page leftPage = this.pageManager.getPage(leftRowId);
            int leftPosition = this.pageManager.getPosition(leftRowId);
            Page rightPage = this.pageManager.getPage(rightRowId);
            int rightPosition = this.pageManager.getPosition(rightRowId);
            return comparator.compareTo(leftPage, leftPosition, rightPage, rightPosition);
        }, topN, this.pageManager::dereference);
    }

    @Override
    public Work<?> processPage(Page page) {
        return new TransformWork<GroupByIdBlock, Object>(this.groupByHash.getGroupIds(page), groupIds -> {
            this.processPage(page, (GroupByIdBlock)groupIds);
            return null;
        });
    }

    @Override
    public Iterator<Page> buildResult() {
        return new ResultIterator();
    }

    @Override
    public long getEstimatedSizeInBytes() {
        return INSTANCE_SIZE + this.groupByHash.getEstimatedSize() + this.pageManager.sizeOf() + this.groupedTopNRowNumberAccumulator.sizeOf();
    }

    private void processPage(Page newPage, GroupByIdBlock groupIds) {
        try (RowReferencePageManager.LoadCursor loadCursor = this.pageManager.add(newPage);){
            for (int position = 0; position < newPage.getPositionCount(); ++position) {
                long groupId = groupIds.getGroupId(position);
                loadCursor.advance();
                this.groupedTopNRowNumberAccumulator.add(groupId, loadCursor);
            }
            Verify.verify((!loadCursor.advance() ? 1 : 0) != 0);
        }
        this.pageManager.compactIfNeeded();
    }

    @VisibleForTesting
    GroupByHash getGroupByHash() {
        return this.groupByHash;
    }

    private class ResultIterator
    extends AbstractIterator<Page> {
        private final PageBuilder pageBuilder;
        private final long groupIdCount;
        private long currentGroupId;
        private final LongBigArray rowIdOutput;
        private long currentGroupSize;
        private int currentIndexInGroup;

        ResultIterator() {
            this.groupIdCount = GroupedTopNRowNumberBuilder.this.groupByHash.getGroupCount();
            this.currentGroupId = -1L;
            this.rowIdOutput = new LongBigArray();
            ImmutableList.Builder sourceTypesBuilders = new ImmutableList.Builder().addAll(GroupedTopNRowNumberBuilder.this.sourceTypes);
            if (GroupedTopNRowNumberBuilder.this.produceRowNumber) {
                sourceTypesBuilders.add((Object)BigintType.BIGINT);
            }
            this.pageBuilder = new PageBuilder((List)sourceTypesBuilders.build());
        }

        protected Page computeNext() {
            this.pageBuilder.reset();
            while (!this.pageBuilder.isFull()) {
                while ((long)this.currentIndexInGroup >= this.currentGroupSize) {
                    if (this.currentGroupId + 1L >= this.groupIdCount) {
                        if (this.pageBuilder.isEmpty()) {
                            return (Page)this.endOfData();
                        }
                        return this.pageBuilder.build();
                    }
                    ++this.currentGroupId;
                    this.currentGroupSize = GroupedTopNRowNumberBuilder.this.groupedTopNRowNumberAccumulator.drainTo(this.currentGroupId, this.rowIdOutput);
                    this.currentIndexInGroup = 0;
                }
                long rowId = this.rowIdOutput.get((long)this.currentIndexInGroup);
                Page page = GroupedTopNRowNumberBuilder.this.pageManager.getPage(rowId);
                int position = GroupedTopNRowNumberBuilder.this.pageManager.getPosition(rowId);
                for (int i = 0; i < GroupedTopNRowNumberBuilder.this.sourceTypes.size(); ++i) {
                    GroupedTopNRowNumberBuilder.this.sourceTypes.get(i).appendTo(page.getBlock(i), position, this.pageBuilder.getBlockBuilder(i));
                }
                if (GroupedTopNRowNumberBuilder.this.produceRowNumber) {
                    BigintType.BIGINT.writeLong(this.pageBuilder.getBlockBuilder(GroupedTopNRowNumberBuilder.this.sourceTypes.size()), (long)(this.currentIndexInGroup + 1));
                }
                this.pageBuilder.declarePosition();
                ++this.currentIndexInGroup;
                GroupedTopNRowNumberBuilder.this.pageManager.dereference(rowId);
            }
            if (this.pageBuilder.isEmpty()) {
                return (Page)this.endOfData();
            }
            return this.pageBuilder.build();
        }
    }
}

