/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator;

import io.trino.operator.HashCollisionsInfo;
import io.trino.operator.OperatorContext;
import io.trino.operator.OperatorInfo;
import java.util.function.Supplier;

public class HashCollisionsCounter
implements Supplier<OperatorInfo> {
    private final OperatorContext operatorContext;
    private long hashCollisions;
    private double expectedHashCollisions;

    public HashCollisionsCounter(OperatorContext operatorContext) {
        this.operatorContext = operatorContext;
    }

    public void recordHashCollision(long hashCollisions, double expectedHashCollisions) {
        this.hashCollisions += hashCollisions;
        this.expectedHashCollisions += expectedHashCollisions;
    }

    @Override
    public HashCollisionsInfo get() {
        return HashCollisionsInfo.createHashCollisionsInfo(this.operatorContext.getInputPositions().getTotalCount(), this.hashCollisions, this.expectedHashCollisions);
    }
}

