/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ListenableFuture;
import io.airlift.concurrent.MoreFutures;
import io.trino.metadata.Metadata;
import io.trino.metadata.QualifiedObjectName;
import io.trino.operator.DriverContext;
import io.trino.operator.Operator;
import io.trino.operator.OperatorContext;
import io.trino.operator.OperatorFactory;
import io.trino.operator.ValuesOperator;
import io.trino.spi.Page;
import io.trino.sql.planner.plan.PlanNodeId;
import java.util.Objects;
import javax.annotation.Nullable;

public class RefreshMaterializedViewOperator
implements Operator {
    private final OperatorContext operatorContext;
    private final Metadata metadata;
    private final QualifiedObjectName viewName;
    @Nullable
    private ListenableFuture<Void> refreshFuture;
    private boolean closed;

    public RefreshMaterializedViewOperator(OperatorContext operatorContext, Metadata metadata, QualifiedObjectName viewName) {
        this.operatorContext = Objects.requireNonNull(operatorContext, "operatorContext is null");
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        this.viewName = Objects.requireNonNull(viewName, "viewName is null");
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public ListenableFuture<Void> isBlocked() {
        if (this.refreshFuture == null) {
            return NOT_BLOCKED;
        }
        return this.refreshFuture;
    }

    @Override
    public boolean needsInput() {
        return false;
    }

    @Override
    public void addInput(Page page) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Page getOutput() {
        return null;
    }

    @Override
    public void finish() {
    }

    @Override
    public void close() {
        if (this.refreshFuture != null) {
            this.refreshFuture.cancel(false);
        }
        this.closed = true;
    }

    @Override
    public boolean isFinished() {
        if (this.closed) {
            return true;
        }
        if (this.refreshFuture == null) {
            this.refreshFuture = this.metadata.refreshMaterializedView(this.operatorContext.getSession(), this.viewName);
        }
        if (this.refreshFuture.isDone()) {
            MoreFutures.getDone(this.refreshFuture);
        }
        return this.refreshFuture.isDone();
    }

    public static class RefreshMaterializedViewOperatorFactory
    implements OperatorFactory {
        private final int operatorId;
        private final PlanNodeId planNodeId;
        private final Metadata metadata;
        private final QualifiedObjectName viewName;
        private boolean closed;

        public RefreshMaterializedViewOperatorFactory(int operatorId, PlanNodeId planNodeId, Metadata metadata, QualifiedObjectName viewName) {
            this.operatorId = operatorId;
            this.planNodeId = Objects.requireNonNull(planNodeId, "planNodeId is null");
            this.metadata = Objects.requireNonNull(metadata, "metadata is null");
            this.viewName = Objects.requireNonNull(viewName, "viewName is null");
        }

        @Override
        public Operator createOperator(DriverContext driverContext) {
            Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Factory is already closed");
            OperatorContext operatorContext = driverContext.addOperatorContext(this.operatorId, this.planNodeId, ValuesOperator.class.getSimpleName());
            return new RefreshMaterializedViewOperator(operatorContext, this.metadata, this.viewName);
        }

        @Override
        public void noMoreOperators() {
            this.closed = true;
        }

        @Override
        public OperatorFactory duplicate() {
            return new RefreshMaterializedViewOperatorFactory(this.operatorId, this.planNodeId, this.metadata, this.viewName);
        }
    }
}

