/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation;

import io.trino.operator.aggregation.state.RegressionState;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.function.AggregationFunction;
import io.trino.spi.function.AggregationState;
import io.trino.spi.function.CombineFunction;
import io.trino.spi.function.InputFunction;
import io.trino.spi.function.OutputFunction;
import io.trino.spi.function.SqlType;
import io.trino.spi.type.DoubleType;

@AggregationFunction
public final class DoubleRegressionAggregation {
    private DoubleRegressionAggregation() {
    }

    @InputFunction
    public static void input(@AggregationState RegressionState state, @SqlType(value="double") double dependentValue, @SqlType(value="double") double independentValue) {
        state.update(independentValue, dependentValue);
    }

    @CombineFunction
    public static void combine(@AggregationState RegressionState state, @AggregationState RegressionState otherState) {
        state.merge(otherState);
    }

    @AggregationFunction(value="regr_slope")
    @OutputFunction(value="double")
    public static void regrSlope(@AggregationState RegressionState state, BlockBuilder out) {
        double result = state.getRegressionSlope();
        if (Double.isFinite(result)) {
            DoubleType.DOUBLE.writeDouble(out, result);
        } else {
            out.appendNull();
        }
    }

    @AggregationFunction(value="regr_intercept")
    @OutputFunction(value="double")
    public static void regrIntercept(@AggregationState RegressionState state, BlockBuilder out) {
        double result = state.getRegressionIntercept();
        if (Double.isFinite(result)) {
            DoubleType.DOUBLE.writeDouble(out, result);
        } else {
            out.appendNull();
        }
    }
}

