/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation.state;

import io.trino.operator.aggregation.state.TriStateBooleanState;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.function.AccumulatorStateSerializer;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.Type;

public class TriStateBooleanStateSerializer
implements AccumulatorStateSerializer<TriStateBooleanState> {
    public Type getSerializedType() {
        return BooleanType.BOOLEAN;
    }

    public void serialize(TriStateBooleanState state, BlockBuilder out) {
        if (state.getValue() == 0) {
            out.appendNull();
        } else {
            out.writeByte(state.getValue() == 1 ? 1 : 0).closeEntry();
        }
    }

    public void deserialize(Block block, int index, TriStateBooleanState state) {
        state.setValue(BooleanType.BOOLEAN.getBoolean(block, index) ? (byte)1 : -1);
    }
}

