/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.join;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.trino.execution.Lifespan;
import io.trino.operator.DriverContext;
import io.trino.operator.HashGenerator;
import io.trino.operator.InterpretedHashGenerator;
import io.trino.operator.Operator;
import io.trino.operator.OperatorContext;
import io.trino.operator.PrecomputedHashGenerator;
import io.trino.operator.ProcessorContext;
import io.trino.operator.WorkProcessor;
import io.trino.operator.WorkProcessorOperator;
import io.trino.operator.WorkProcessorOperatorAdapter;
import io.trino.operator.join.JoinBridgeManager;
import io.trino.operator.join.JoinOperatorFactory;
import io.trino.operator.join.JoinProbe;
import io.trino.operator.join.LookupJoinOperator;
import io.trino.operator.join.LookupOuterOperator;
import io.trino.operator.join.LookupSourceFactory;
import io.trino.spi.Page;
import io.trino.spi.type.Type;
import io.trino.spiller.PartitioningSpillerFactory;
import io.trino.sql.planner.plan.PlanNodeId;
import io.trino.type.BlockTypeOperators;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;

public class LookupJoinOperatorFactory
implements JoinOperatorFactory,
WorkProcessorOperatorAdapter.AdapterWorkProcessorOperatorFactory {
    private final int operatorId;
    private final PlanNodeId planNodeId;
    private final List<Type> probeTypes;
    private final List<Type> buildOutputTypes;
    private final JoinType joinType;
    private final boolean outputSingleMatch;
    private final boolean waitForBuild;
    private final JoinProbe.JoinProbeFactory joinProbeFactory;
    private final Optional<JoinOperatorFactory.OuterOperatorFactoryResult> outerOperatorFactoryResult;
    private final JoinBridgeManager<? extends LookupSourceFactory> joinBridgeManager;
    private final OptionalInt totalOperatorsCount;
    private final HashGenerator probeHashGenerator;
    private final PartitioningSpillerFactory partitioningSpillerFactory;
    private boolean closed;

    public LookupJoinOperatorFactory(int operatorId, PlanNodeId planNodeId, JoinBridgeManager<? extends LookupSourceFactory> lookupSourceFactoryManager, List<Type> probeTypes, List<Type> probeOutputTypes, List<Type> buildOutputTypes, JoinType joinType, boolean outputSingleMatch, boolean waitForBuild, JoinProbe.JoinProbeFactory joinProbeFactory, BlockTypeOperators blockTypeOperators, OptionalInt totalOperatorsCount, List<Integer> probeJoinChannels, OptionalInt probeHashChannel, PartitioningSpillerFactory partitioningSpillerFactory) {
        this.operatorId = operatorId;
        this.planNodeId = Objects.requireNonNull(planNodeId, "planNodeId is null");
        this.probeTypes = ImmutableList.copyOf((Collection)Objects.requireNonNull(probeTypes, "probeTypes is null"));
        this.buildOutputTypes = ImmutableList.copyOf((Collection)Objects.requireNonNull(buildOutputTypes, "buildOutputTypes is null"));
        this.joinType = Objects.requireNonNull(joinType, "joinType is null");
        this.outputSingleMatch = outputSingleMatch;
        this.waitForBuild = waitForBuild;
        this.joinProbeFactory = Objects.requireNonNull(joinProbeFactory, "joinProbeFactory is null");
        this.joinBridgeManager = lookupSourceFactoryManager;
        this.joinBridgeManager.incrementProbeFactoryCount();
        this.outerOperatorFactoryResult = joinType == JoinType.INNER || joinType == JoinType.PROBE_OUTER ? Optional.empty() : Optional.of(new JoinOperatorFactory.OuterOperatorFactoryResult(new LookupOuterOperator.LookupOuterOperatorFactory(operatorId, planNodeId, probeOutputTypes, buildOutputTypes, lookupSourceFactoryManager), lookupSourceFactoryManager.getBuildExecutionStrategy()));
        this.totalOperatorsCount = Objects.requireNonNull(totalOperatorsCount, "totalOperatorsCount is null");
        Objects.requireNonNull(probeHashChannel, "probeHashChannel is null");
        if (probeHashChannel.isPresent()) {
            this.probeHashGenerator = new PrecomputedHashGenerator(probeHashChannel.getAsInt());
        } else {
            Objects.requireNonNull(probeJoinChannels, "probeJoinChannels is null");
            List hashTypes = (List)probeJoinChannels.stream().map(probeTypes::get).collect(ImmutableList.toImmutableList());
            this.probeHashGenerator = new InterpretedHashGenerator((List<Type>)hashTypes, probeJoinChannels, blockTypeOperators);
        }
        this.partitioningSpillerFactory = Objects.requireNonNull(partitioningSpillerFactory, "partitioningSpillerFactory is null");
    }

    private LookupJoinOperatorFactory(LookupJoinOperatorFactory other) {
        Objects.requireNonNull(other, "other is null");
        Preconditions.checkArgument((!other.closed ? 1 : 0) != 0, (Object)"cannot duplicated closed OperatorFactory");
        this.operatorId = other.operatorId;
        this.planNodeId = other.planNodeId;
        this.probeTypes = other.probeTypes;
        this.buildOutputTypes = other.buildOutputTypes;
        this.joinType = other.joinType;
        this.outputSingleMatch = other.outputSingleMatch;
        this.waitForBuild = other.waitForBuild;
        this.joinProbeFactory = other.joinProbeFactory;
        this.joinBridgeManager = other.joinBridgeManager;
        this.outerOperatorFactoryResult = other.outerOperatorFactoryResult;
        this.totalOperatorsCount = other.totalOperatorsCount;
        this.probeHashGenerator = other.probeHashGenerator;
        this.partitioningSpillerFactory = other.partitioningSpillerFactory;
        this.closed = false;
        this.joinBridgeManager.incrementProbeFactoryCount();
    }

    @Override
    public Optional<JoinOperatorFactory.OuterOperatorFactoryResult> createOuterOperatorFactory() {
        return this.outerOperatorFactoryResult;
    }

    @Override
    public Operator createOperator(DriverContext driverContext) {
        OperatorContext operatorContext = driverContext.addOperatorContext(this.getOperatorId(), this.getPlanNodeId(), this.getOperatorType());
        return new WorkProcessorOperatorAdapter(operatorContext, this);
    }

    @Override
    public void noMoreOperators() {
        this.close();
    }

    @Override
    public void noMoreOperators(Lifespan lifespan) {
        this.lifespanFinished(lifespan);
    }

    @Override
    public int getOperatorId() {
        return this.operatorId;
    }

    @Override
    public PlanNodeId getPlanNodeId() {
        return this.planNodeId;
    }

    @Override
    public String getOperatorType() {
        return LookupJoinOperator.class.getSimpleName();
    }

    @Override
    public WorkProcessorOperator create(ProcessorContext processorContext, WorkProcessor<Page> sourcePages) {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Factory is already closed");
        LookupSourceFactory lookupSourceFactory = this.joinBridgeManager.getJoinBridge(processorContext.getLifespan());
        this.joinBridgeManager.probeOperatorCreated(processorContext.getLifespan());
        return new LookupJoinOperator(this.probeTypes, this.buildOutputTypes, this.joinType, this.outputSingleMatch, this.waitForBuild, lookupSourceFactory, this.joinProbeFactory, () -> this.joinBridgeManager.probeOperatorClosed(processorContext.getLifespan()), this.totalOperatorsCount, this.probeHashGenerator, this.partitioningSpillerFactory, processorContext, Optional.of(sourcePages));
    }

    @Override
    public WorkProcessorOperatorAdapter.AdapterWorkProcessorOperator createAdapterOperator(ProcessorContext processorContext) {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Factory is already closed");
        LookupSourceFactory lookupSourceFactory = this.joinBridgeManager.getJoinBridge(processorContext.getLifespan());
        this.joinBridgeManager.probeOperatorCreated(processorContext.getLifespan());
        return new LookupJoinOperator(this.probeTypes, this.buildOutputTypes, this.joinType, this.outputSingleMatch, this.waitForBuild, lookupSourceFactory, this.joinProbeFactory, () -> this.joinBridgeManager.probeOperatorClosed(processorContext.getLifespan()), this.totalOperatorsCount, this.probeHashGenerator, this.partitioningSpillerFactory, processorContext, Optional.empty());
    }

    @Override
    public void lifespanFinished(Lifespan lifespan) {
        this.joinBridgeManager.probeOperatorFactoryClosed(lifespan);
    }

    @Override
    public void close() {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        this.closed = true;
        this.joinBridgeManager.probeOperatorFactoryClosedForAllLifespans();
    }

    @Override
    public LookupJoinOperatorFactory duplicate() {
        return new LookupJoinOperatorFactory(this);
    }

    public static enum JoinType {
        INNER,
        PROBE_OUTER,
        LOOKUP_OUTER,
        FULL_OUTER;

    }
}

