/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar;

import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.function.CastDependency;
import io.trino.spi.function.Convention;
import io.trino.spi.function.InvocationConvention;
import io.trino.spi.function.OperatorType;
import io.trino.spi.function.ScalarOperator;
import io.trino.spi.function.SqlType;
import io.trino.spi.function.TypeParameter;
import io.trino.spi.function.TypeParameterSpecialization;
import io.trino.spi.function.TypeParameters;
import io.trino.spi.type.Type;
import java.lang.invoke.MethodHandle;

@ScalarOperator(value=OperatorType.CAST)
public final class ArrayToArrayCast {
    private ArrayToArrayCast() {
    }

    @TypeParameters(value={@TypeParameter(value="F"), @TypeParameter(value="T")})
    @TypeParameterSpecialization(name="T", nativeContainerType=long.class)
    @SqlType(value="array(T)")
    public static Block filterLong(@TypeParameter(value="T") Type resultType, @CastDependency(fromType="F", toType="T", convention=@Convention(arguments={InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION}, result=InvocationConvention.InvocationReturnConvention.NULLABLE_RETURN, session=true)) MethodHandle cast, ConnectorSession session, @SqlType(value="array(F)") Block array) throws Throwable {
        int positionCount = array.getPositionCount();
        BlockBuilder resultBuilder = resultType.createBlockBuilder(null, positionCount);
        for (int position = 0; position < positionCount; ++position) {
            Long value;
            if (!array.isNull(position) && (value = cast.invokeExact(session, array, position)) != null) {
                resultType.writeLong(resultBuilder, value.longValue());
                continue;
            }
            resultBuilder.appendNull();
        }
        return resultBuilder.build();
    }

    @TypeParameters(value={@TypeParameter(value="F"), @TypeParameter(value="T")})
    @TypeParameterSpecialization(name="T", nativeContainerType=double.class)
    @SqlType(value="array(T)")
    public static Block filterDouble(@TypeParameter(value="T") Type resultType, @CastDependency(fromType="F", toType="T", convention=@Convention(arguments={InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION}, result=InvocationConvention.InvocationReturnConvention.NULLABLE_RETURN, session=true)) MethodHandle cast, ConnectorSession session, @SqlType(value="array(F)") Block array) throws Throwable {
        int positionCount = array.getPositionCount();
        BlockBuilder resultBuilder = resultType.createBlockBuilder(null, positionCount);
        for (int position = 0; position < positionCount; ++position) {
            Double value;
            if (!array.isNull(position) && (value = cast.invokeExact(session, array, position)) != null) {
                resultType.writeDouble(resultBuilder, value.doubleValue());
                continue;
            }
            resultBuilder.appendNull();
        }
        return resultBuilder.build();
    }

    @TypeParameters(value={@TypeParameter(value="F"), @TypeParameter(value="T")})
    @TypeParameterSpecialization(name="T", nativeContainerType=boolean.class)
    @SqlType(value="array(T)")
    public static Block filterBoolean(@TypeParameter(value="T") Type resultType, @CastDependency(fromType="F", toType="T", convention=@Convention(arguments={InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION}, result=InvocationConvention.InvocationReturnConvention.NULLABLE_RETURN, session=true)) MethodHandle cast, ConnectorSession session, @SqlType(value="array(F)") Block array) throws Throwable {
        int positionCount = array.getPositionCount();
        BlockBuilder resultBuilder = resultType.createBlockBuilder(null, positionCount);
        for (int position = 0; position < positionCount; ++position) {
            Boolean value;
            if (!array.isNull(position) && (value = cast.invokeExact(session, array, position)) != null) {
                resultType.writeBoolean(resultBuilder, value.booleanValue());
                continue;
            }
            resultBuilder.appendNull();
        }
        return resultBuilder.build();
    }

    @TypeParameters(value={@TypeParameter(value="F"), @TypeParameter(value="T")})
    @TypeParameterSpecialization(name="T", nativeContainerType=Object.class)
    @SqlType(value="array(T)")
    public static Block filterObject(@TypeParameter(value="T") Type resultType, @CastDependency(fromType="F", toType="T", convention=@Convention(arguments={InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION}, result=InvocationConvention.InvocationReturnConvention.NULLABLE_RETURN, session=true)) MethodHandle cast, ConnectorSession session, @SqlType(value="array(F)") Block array) throws Throwable {
        int positionCount = array.getPositionCount();
        BlockBuilder resultBuilder = resultType.createBlockBuilder(null, positionCount);
        for (int position = 0; position < positionCount; ++position) {
            Object value;
            if (!array.isNull(position) && (value = cast.invoke(session, array, position)) != null) {
                resultType.writeObject(resultBuilder, value);
                continue;
            }
            resultBuilder.appendNull();
        }
        return resultBuilder.build();
    }
}

