/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar.timestamp;

import io.trino.spi.function.Description;
import io.trino.spi.function.LiteralParameters;
import io.trino.spi.function.ScalarFunction;
import io.trino.spi.function.SqlType;
import io.trino.spi.type.LongTimestamp;
import io.trino.type.DateTimes;
import org.joda.time.chrono.ISOChronology;

@Description(value="Year of the ISO week of the given timestamp")
@ScalarFunction(value="year_of_week", alias={"yow"})
public class ExtractYearOfWeek {
    private ExtractYearOfWeek() {
    }

    @LiteralParameters(value={"p"})
    @SqlType(value="bigint")
    public static long extract(@SqlType(value="timestamp(p)") long timestamp) {
        return ISOChronology.getInstanceUTC().weekyear().get(DateTimes.scaleEpochMicrosToMillis(timestamp));
    }

    @LiteralParameters(value={"p"})
    @SqlType(value="bigint")
    public static long extract(@SqlType(value="timestamp(p)") LongTimestamp timestamp) {
        return ExtractYearOfWeek.extract(timestamp.getEpochMicros());
    }
}

