/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.window;

import io.trino.spi.block.BlockBuilder;
import io.trino.spi.function.RankingWindowFunction;
import io.trino.spi.function.WindowFunctionSignature;
import io.trino.spi.type.DoubleType;

@WindowFunctionSignature(name="cume_dist", returnType="double")
public class CumulativeDistributionFunction
extends RankingWindowFunction {
    private long totalCount;
    private long count;

    public void reset() {
        this.totalCount = this.windowIndex.size();
        this.count = 0L;
    }

    public void processRow(BlockBuilder output, boolean newPeerGroup, int peerGroupCount, int currentPosition) {
        if (newPeerGroup) {
            this.count += (long)peerGroupCount;
        }
        DoubleType.DOUBLE.writeDouble(output, (double)this.count / (double)this.totalCount);
    }
}

