/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.window.matcher;

import io.trino.operator.window.matcher.Done;
import io.trino.operator.window.matcher.Jump;
import io.trino.operator.window.matcher.MatchEnd;
import io.trino.operator.window.matcher.MatchLabel;
import io.trino.operator.window.matcher.MatchStart;
import io.trino.operator.window.matcher.Save;
import io.trino.operator.window.matcher.Split;

interface Instruction {
    public Type type();

    public static Jump jump(int target) {
        return new Jump(target);
    }

    public static Save save() {
        return new Save();
    }

    public static Split split(int first, int second) {
        return new Split(first, second);
    }

    public static Done done() {
        return new Done();
    }

    public static MatchLabel match(int label) {
        return new MatchLabel(label);
    }

    public static MatchStart matchStart() {
        return new MatchStart();
    }

    public static MatchEnd matchEnd() {
        return new MatchEnd();
    }

    public static enum Type {
        JUMP,
        MATCH_LABEL,
        MATCH_START,
        MATCH_END,
        SAVE,
        SPLIT,
        DONE;

    }
}

