/*
 * Decompiled with CFR 0.152.
 */
package io.trino.server;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import io.trino.execution.resourcegroups.ResourceGroupManager;
import io.trino.server.ResourceGroupInfo;
import io.trino.server.security.ResourceSecurity;
import io.trino.spi.resourcegroups.ResourceGroupId;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.inject.Inject;
import javax.ws.rs.Encoded;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;

@Path(value="/v1/resourceGroupState")
public class ResourceGroupStateInfoResource {
    private final ResourceGroupManager<?> resourceGroupManager;

    @Inject
    public ResourceGroupStateInfoResource(ResourceGroupManager<?> resourceGroupManager) {
        this.resourceGroupManager = Objects.requireNonNull(resourceGroupManager, "resourceGroupManager is null");
    }

    @ResourceSecurity(value=ResourceSecurity.AccessType.MANAGEMENT_READ)
    @GET
    @Produces(value={"application/json"})
    @Encoded
    @Path(value="{resourceGroupId: .+}")
    public ResourceGroupInfo getQueryStateInfos(@PathParam(value="resourceGroupId") String resourceGroupIdString) {
        if (!Strings.isNullOrEmpty((String)resourceGroupIdString)) {
            return this.resourceGroupManager.tryGetResourceGroupInfo(new ResourceGroupId((List)Arrays.stream(resourceGroupIdString.split("/")).map(ResourceGroupStateInfoResource::urlDecode).collect(ImmutableList.toImmutableList()))).orElseThrow(() -> new WebApplicationException(Response.Status.NOT_FOUND));
        }
        throw new WebApplicationException(Response.Status.NOT_FOUND);
    }

    private static String urlDecode(String value) {
        return URLDecoder.decode(value, StandardCharsets.UTF_8);
    }
}

