/*
 * Decompiled with CFR 0.152.
 */
package io.trino.testing;

import java.util.Arrays;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public final class Bytes {
    private final byte[] bytes;

    public static Bytes fromBytes(byte ... bytes) {
        return new Bytes(bytes);
    }

    private Bytes(byte[] bytes) {
        this.bytes = (byte[])bytes.clone();
    }

    public byte[] getBytes() {
        return (byte[])this.bytes.clone();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Bytes other = (Bytes)o;
        return Arrays.equals(this.bytes, other.bytes);
    }

    public int hashCode() {
        return Arrays.hashCode(this.bytes);
    }

    public String toString() {
        return IntStream.range(0, this.bytes.length).mapToObj(i -> String.format("%02x", this.bytes[i] & 0xFF)).collect(Collectors.joining(" ", "X'", "'"));
    }
}

