/*
 * Decompiled with CFR 0.152.
 */
package io.trino.decoder.json;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import io.trino.decoder.DecoderColumnHandle;
import io.trino.decoder.RowDecoder;
import io.trino.decoder.RowDecoderFactory;
import io.trino.decoder.json.CustomDateTimeJsonFieldDecoder;
import io.trino.decoder.json.DefaultJsonFieldDecoder;
import io.trino.decoder.json.ISO8601JsonFieldDecoder;
import io.trino.decoder.json.JsonFieldDecoder;
import io.trino.decoder.json.JsonRowDecoder;
import io.trino.decoder.json.MillisecondsSinceEpochJsonFieldDecoder;
import io.trino.decoder.json.RFC2822JsonFieldDecoder;
import io.trino.decoder.json.SecondsSinceEpochJsonFieldDecoder;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import javax.inject.Inject;

public class JsonRowDecoderFactory
implements RowDecoderFactory {
    private final ObjectMapper objectMapper;

    @Inject
    public JsonRowDecoderFactory(ObjectMapper objectMapper) {
        this.objectMapper = Objects.requireNonNull(objectMapper, "objectMapper is null");
    }

    @Override
    public RowDecoder create(Map<String, String> decoderParams, Set<DecoderColumnHandle> columns) {
        Objects.requireNonNull(columns, "columns is null");
        return new JsonRowDecoder(this.objectMapper, this.chooseFieldDecoders(columns));
    }

    private Map<DecoderColumnHandle, JsonFieldDecoder> chooseFieldDecoders(Set<DecoderColumnHandle> columns) {
        return (Map)columns.stream().collect(ImmutableMap.toImmutableMap(Function.identity(), this::chooseFieldDecoder));
    }

    private JsonFieldDecoder chooseFieldDecoder(DecoderColumnHandle column) {
        try {
            String dataFormat;
            Objects.requireNonNull(column);
            Preconditions.checkArgument((!column.isInternal() ? 1 : 0) != 0, (String)"unexpected internal column '%s'", (Object)column.getName());
            switch (dataFormat = Optional.ofNullable(column.getDataFormat()).orElse("")) {
                case "custom-date-time": {
                    return new CustomDateTimeJsonFieldDecoder(column);
                }
                case "iso8601": {
                    return new ISO8601JsonFieldDecoder(column);
                }
                case "seconds-since-epoch": {
                    return new SecondsSinceEpochJsonFieldDecoder(column);
                }
                case "milliseconds-since-epoch": {
                    return new MillisecondsSinceEpochJsonFieldDecoder(column);
                }
                case "rfc2822": {
                    return new RFC2822JsonFieldDecoder(column);
                }
                case "": {
                    return new DefaultJsonFieldDecoder(column);
                }
            }
            throw new IllegalArgumentException(String.format("unknown data format '%s' used for column '%s'", column.getDataFormat(), column.getName()));
        }
        catch (IllegalArgumentException e) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_USER_ERROR, (Throwable)e);
        }
    }

    public static JsonFieldDecoder throwUnsupportedColumnType(DecoderColumnHandle column) {
        if (column.getDataFormat() == null) {
            throw new IllegalArgumentException(String.format("unsupported column type '%s' for column '%s'", column.getType().getDisplayName(), column.getName()));
        }
        throw new IllegalArgumentException(String.format("unsupported column type '%s' for column '%s' with data format '%s'", column.getType(), column.getName(), column.getDataFormat()));
    }
}

