/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.bytecode.control;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.airlift.bytecode.BytecodeBlock;
import io.airlift.bytecode.BytecodeNode;
import io.airlift.bytecode.BytecodeVisitor;
import io.airlift.bytecode.MethodGenerationContext;
import io.airlift.bytecode.control.FlowControl;
import io.airlift.bytecode.instruction.LabelNode;
import java.util.List;
import org.objectweb.asm.MethodVisitor;

public class IfStatement
implements FlowControl {
    private final String comment;
    private final BytecodeBlock condition = new BytecodeBlock();
    private final BytecodeBlock ifTrue = new BytecodeBlock();
    private final BytecodeBlock ifFalse = new BytecodeBlock();
    private final LabelNode falseLabel = new LabelNode("false");
    private final LabelNode outLabel = new LabelNode("out");

    public IfStatement() {
        this.comment = null;
    }

    public IfStatement(String format, Object ... args) {
        this.comment = String.format(format, args);
    }

    @Override
    public String getComment() {
        return this.comment;
    }

    public BytecodeBlock condition() {
        return this.condition;
    }

    public IfStatement condition(BytecodeNode node) {
        Preconditions.checkState((boolean)this.condition.isEmpty(), (Object)"condition already set");
        this.condition.append(node);
        return this;
    }

    public BytecodeBlock ifTrue() {
        return this.ifTrue;
    }

    public IfStatement ifTrue(BytecodeNode node) {
        Preconditions.checkState((boolean)this.ifTrue.isEmpty(), (Object)"ifTrue already set");
        this.ifTrue.append(node);
        return this;
    }

    public BytecodeBlock ifFalse() {
        return this.ifFalse;
    }

    public IfStatement ifFalse(BytecodeNode node) {
        Preconditions.checkState((boolean)this.ifFalse.isEmpty(), (Object)"ifFalse already set");
        this.ifFalse.append(node);
        return this;
    }

    @Override
    public void accept(MethodVisitor visitor, MethodGenerationContext generationContext) {
        Preconditions.checkState((!this.condition.isEmpty() ? 1 : 0) != 0, (Object)"IfStatement does not have a condition set");
        Preconditions.checkState((!this.ifTrue.isEmpty() || !this.ifFalse.isEmpty() ? 1 : 0) != 0, (Object)"IfStatement does not have a true or false block set");
        BytecodeBlock block = new BytecodeBlock();
        block.append(new BytecodeBlock().setDescription("condition").append(this.condition));
        block.ifFalseGoto(this.falseLabel);
        if (!this.ifTrue.isEmpty()) {
            block.append(new BytecodeBlock().setDescription("ifTrue").append(this.ifTrue));
        }
        if (!this.ifFalse.isEmpty()) {
            block.gotoLabel(this.outLabel);
            block.visitLabel(this.falseLabel);
            block.append(new BytecodeBlock().setDescription("ifFalse").append(this.ifFalse));
            block.visitLabel(this.outLabel);
        } else {
            block.visitLabel(this.falseLabel);
        }
        block.accept(visitor, generationContext);
    }

    @Override
    public List<BytecodeNode> getChildNodes() {
        return ImmutableList.of((Object)this.condition, (Object)this.ifTrue, (Object)this.ifFalse);
    }

    @Override
    public <T> T accept(BytecodeNode parent, BytecodeVisitor<T> visitor) {
        return visitor.visitIf(parent, this);
    }
}

