/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.tree;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import io.trino.sql.tree.ArithmeticBinaryExpression;
import io.trino.sql.tree.ArithmeticUnaryExpression;
import io.trino.sql.tree.ArrayConstructor;
import io.trino.sql.tree.AstVisitor;
import io.trino.sql.tree.AtTimeZone;
import io.trino.sql.tree.BetweenPredicate;
import io.trino.sql.tree.BindExpression;
import io.trino.sql.tree.Cast;
import io.trino.sql.tree.CoalesceExpression;
import io.trino.sql.tree.ComparisonExpression;
import io.trino.sql.tree.CurrentCatalog;
import io.trino.sql.tree.CurrentPath;
import io.trino.sql.tree.CurrentSchema;
import io.trino.sql.tree.CurrentTime;
import io.trino.sql.tree.CurrentUser;
import io.trino.sql.tree.DataType;
import io.trino.sql.tree.DataTypeParameter;
import io.trino.sql.tree.DateTimeDataType;
import io.trino.sql.tree.DereferenceExpression;
import io.trino.sql.tree.ExistsPredicate;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.ExpressionRewriter;
import io.trino.sql.tree.Extract;
import io.trino.sql.tree.FieldReference;
import io.trino.sql.tree.Format;
import io.trino.sql.tree.FrameBound;
import io.trino.sql.tree.FunctionCall;
import io.trino.sql.tree.GenericDataType;
import io.trino.sql.tree.GroupingOperation;
import io.trino.sql.tree.Identifier;
import io.trino.sql.tree.IfExpression;
import io.trino.sql.tree.InListExpression;
import io.trino.sql.tree.InPredicate;
import io.trino.sql.tree.IntervalDayTimeDataType;
import io.trino.sql.tree.IsNotNullPredicate;
import io.trino.sql.tree.IsNullPredicate;
import io.trino.sql.tree.LabelDereference;
import io.trino.sql.tree.LambdaExpression;
import io.trino.sql.tree.LikePredicate;
import io.trino.sql.tree.Literal;
import io.trino.sql.tree.LogicalExpression;
import io.trino.sql.tree.NotExpression;
import io.trino.sql.tree.NullIfExpression;
import io.trino.sql.tree.NumericParameter;
import io.trino.sql.tree.OrderBy;
import io.trino.sql.tree.Parameter;
import io.trino.sql.tree.QuantifiedComparisonExpression;
import io.trino.sql.tree.Row;
import io.trino.sql.tree.RowDataType;
import io.trino.sql.tree.SearchedCaseExpression;
import io.trino.sql.tree.SimpleCaseExpression;
import io.trino.sql.tree.SortItem;
import io.trino.sql.tree.SubqueryExpression;
import io.trino.sql.tree.SubscriptExpression;
import io.trino.sql.tree.SymbolReference;
import io.trino.sql.tree.TryExpression;
import io.trino.sql.tree.TypeParameter;
import io.trino.sql.tree.WhenClause;
import io.trino.sql.tree.Window;
import io.trino.sql.tree.WindowFrame;
import io.trino.sql.tree.WindowOperation;
import io.trino.sql.tree.WindowReference;
import io.trino.sql.tree.WindowSpecification;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;

public final class ExpressionTreeRewriter<C> {
    private final ExpressionRewriter<C> rewriter;
    private final AstVisitor<Expression, Context<C>> visitor;

    public static <T extends Expression> T rewriteWith(ExpressionRewriter<Void> rewriter, T node) {
        return new ExpressionTreeRewriter<Void>(rewriter).rewrite(node, null);
    }

    public static <C, T extends Expression> T rewriteWith(ExpressionRewriter<C> rewriter, T node, C context) {
        return new ExpressionTreeRewriter<C>(rewriter).rewrite(node, context);
    }

    public ExpressionTreeRewriter(ExpressionRewriter<C> rewriter) {
        this.rewriter = rewriter;
        this.visitor = new RewritingVisitor();
    }

    private List<Expression> rewrite(List<Expression> items, Context<C> context) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Expression expression : items) {
            builder.add((Object)this.rewrite(expression, context.get()));
        }
        return builder.build();
    }

    public <T extends Expression> T rewrite(T node, C context) {
        return (T)this.visitor.process(node, new Context(context, false));
    }

    public <T extends Expression> T defaultRewrite(T node, C context) {
        return (T)this.visitor.process(node, new Context(context, true));
    }

    private static <T> boolean sameElements(Optional<T> a, Optional<T> b) {
        if (!a.isPresent() && !b.isPresent()) {
            return true;
        }
        if (a.isPresent() != b.isPresent()) {
            return false;
        }
        return a.get() == b.get();
    }

    private static <T> boolean sameElements(Iterable<? extends T> a, Iterable<? extends T> b) {
        if (Iterables.size(a) != Iterables.size(b)) {
            return false;
        }
        Iterator<T> first = a.iterator();
        Iterator<T> second = b.iterator();
        while (first.hasNext() && second.hasNext()) {
            if (first.next() == second.next()) continue;
            return false;
        }
        return true;
    }

    public static class Context<C> {
        private final boolean defaultRewrite;
        private final C context;

        private Context(C context, boolean defaultRewrite) {
            this.context = context;
            this.defaultRewrite = defaultRewrite;
        }

        public C get() {
            return this.context;
        }

        public boolean isDefaultRewrite() {
            return this.defaultRewrite;
        }
    }

    private class RewritingVisitor
    extends AstVisitor<Expression, Context<C>> {
        private RewritingVisitor() {
        }

        @Override
        protected Expression visitExpression(Expression node, Context<C> context) {
            throw new UnsupportedOperationException("visit() not implemented for " + node.getClass().getName());
        }

        @Override
        protected Expression visitRow(Row node, Context<C> context) {
            Expression result;
            if (!context.isDefaultRewrite() && (result = ExpressionTreeRewriter.this.rewriter.rewriteRow(node, context.get(), ExpressionTreeRewriter.this)) != null) {
                return result;
            }
            List items = ExpressionTreeRewriter.this.rewrite((Expression)((Object)node.getItems()), (Object)context);
            if (!ExpressionTreeRewriter.sameElements(node.getItems(), items)) {
                return new Row(items);
            }
            return node;
        }

        @Override
        protected Expression visitArithmeticUnary(ArithmeticUnaryExpression node, Context<C> context) {
            Expression result;
            if (!context.isDefaultRewrite() && (result = ExpressionTreeRewriter.this.rewriter.rewriteArithmeticUnary(node, context.get(), ExpressionTreeRewriter.this)) != null) {
                return result;
            }
            Expression child = ExpressionTreeRewriter.this.rewrite(node.getValue(), context.get());
            if (child != node.getValue()) {
                return new ArithmeticUnaryExpression(node.getSign(), child);
            }
            return node;
        }

        @Override
        public Expression visitArithmeticBinary(ArithmeticBinaryExpression node, Context<C> context) {
            Expression result;
            if (!context.isDefaultRewrite() && (result = ExpressionTreeRewriter.this.rewriter.rewriteArithmeticBinary(node, context.get(), ExpressionTreeRewriter.this)) != null) {
                return result;
            }
            Expression left = ExpressionTreeRewriter.this.rewrite(node.getLeft(), context.get());
            Expression right = ExpressionTreeRewriter.this.rewrite(node.getRight(), context.get());
            if (left != node.getLeft() || right != node.getRight()) {
                return new ArithmeticBinaryExpression(node.getOperator(), left, right);
            }
            return node;
        }

        @Override
        protected Expression visitArrayConstructor(ArrayConstructor node, Context<C> context) {
            Expression result;
            if (!context.isDefaultRewrite() && (result = ExpressionTreeRewriter.this.rewriter.rewriteArrayConstructor(node, context.get(), ExpressionTreeRewriter.this)) != null) {
                return result;
            }
            List values = ExpressionTreeRewriter.this.rewrite((Expression)((Object)node.getValues()), (Object)context);
            if (!ExpressionTreeRewriter.sameElements(node.getValues(), values)) {
                return new ArrayConstructor(values);
            }
            return node;
        }

        @Override
        protected Expression visitAtTimeZone(AtTimeZone node, Context<C> context) {
            Expression result;
            if (!context.isDefaultRewrite() && (result = ExpressionTreeRewriter.this.rewriter.rewriteAtTimeZone(node, context.get(), ExpressionTreeRewriter.this)) != null) {
                return result;
            }
            Expression value = ExpressionTreeRewriter.this.rewrite(node.getValue(), context.get());
            Expression timeZone = ExpressionTreeRewriter.this.rewrite(node.getTimeZone(), context.get());
            if (value != node.getValue() || timeZone != node.getTimeZone()) {
                return new AtTimeZone(value, timeZone);
            }
            return node;
        }

        @Override
        protected Expression visitSubscriptExpression(SubscriptExpression node, Context<C> context) {
            Expression result;
            if (!context.isDefaultRewrite() && (result = ExpressionTreeRewriter.this.rewriter.rewriteSubscriptExpression(node, context.get(), ExpressionTreeRewriter.this)) != null) {
                return result;
            }
            Expression base = ExpressionTreeRewriter.this.rewrite(node.getBase(), context.get());
            Expression index = ExpressionTreeRewriter.this.rewrite(node.getIndex(), context.get());
            if (base != node.getBase() || index != node.getIndex()) {
                return new SubscriptExpression(base, index);
            }
            return node;
        }

        @Override
        public Expression visitComparisonExpression(ComparisonExpression node, Context<C> context) {
            Expression result;
            if (!context.isDefaultRewrite() && (result = ExpressionTreeRewriter.this.rewriter.rewriteComparisonExpression(node, context.get(), ExpressionTreeRewriter.this)) != null) {
                return result;
            }
            Expression left = ExpressionTreeRewriter.this.rewrite(node.getLeft(), context.get());
            Expression right = ExpressionTreeRewriter.this.rewrite(node.getRight(), context.get());
            if (left != node.getLeft() || right != node.getRight()) {
                return new ComparisonExpression(node.getOperator(), left, right);
            }
            return node;
        }

        @Override
        protected Expression visitBetweenPredicate(BetweenPredicate node, Context<C> context) {
            Expression result;
            if (!context.isDefaultRewrite() && (result = ExpressionTreeRewriter.this.rewriter.rewriteBetweenPredicate(node, context.get(), ExpressionTreeRewriter.this)) != null) {
                return result;
            }
            Expression value = ExpressionTreeRewriter.this.rewrite(node.getValue(), context.get());
            Expression min = ExpressionTreeRewriter.this.rewrite(node.getMin(), context.get());
            Expression max = ExpressionTreeRewriter.this.rewrite(node.getMax(), context.get());
            if (value != node.getValue() || min != node.getMin() || max != node.getMax()) {
                return new BetweenPredicate(value, min, max);
            }
            return node;
        }

        @Override
        public Expression visitLogicalExpression(LogicalExpression node, Context<C> context) {
            Expression result;
            if (!context.isDefaultRewrite() && (result = ExpressionTreeRewriter.this.rewriter.rewriteLogicalExpression(node, context.get(), ExpressionTreeRewriter.this)) != null) {
                return result;
            }
            List terms = ExpressionTreeRewriter.this.rewrite((Expression)((Object)node.getTerms()), (Object)context);
            if (!ExpressionTreeRewriter.sameElements(node.getTerms(), terms)) {
                return new LogicalExpression(node.getOperator(), terms);
            }
            return node;
        }

        @Override
        public Expression visitNotExpression(NotExpression node, Context<C> context) {
            Expression result;
            if (!context.isDefaultRewrite() && (result = ExpressionTreeRewriter.this.rewriter.rewriteNotExpression(node, context.get(), ExpressionTreeRewriter.this)) != null) {
                return result;
            }
            Expression value = ExpressionTreeRewriter.this.rewrite(node.getValue(), context.get());
            if (value != node.getValue()) {
                return new NotExpression(value);
            }
            return node;
        }

        @Override
        protected Expression visitIsNullPredicate(IsNullPredicate node, Context<C> context) {
            Expression result;
            if (!context.isDefaultRewrite() && (result = ExpressionTreeRewriter.this.rewriter.rewriteIsNullPredicate(node, context.get(), ExpressionTreeRewriter.this)) != null) {
                return result;
            }
            Expression value = ExpressionTreeRewriter.this.rewrite(node.getValue(), context.get());
            if (value != node.getValue()) {
                return new IsNullPredicate(value);
            }
            return node;
        }

        @Override
        protected Expression visitIsNotNullPredicate(IsNotNullPredicate node, Context<C> context) {
            Expression result;
            if (!context.isDefaultRewrite() && (result = ExpressionTreeRewriter.this.rewriter.rewriteIsNotNullPredicate(node, context.get(), ExpressionTreeRewriter.this)) != null) {
                return result;
            }
            Expression value = ExpressionTreeRewriter.this.rewrite(node.getValue(), context.get());
            if (value != node.getValue()) {
                return new IsNotNullPredicate(value);
            }
            return node;
        }

        @Override
        protected Expression visitNullIfExpression(NullIfExpression node, Context<C> context) {
            Expression result;
            if (!context.isDefaultRewrite() && (result = ExpressionTreeRewriter.this.rewriter.rewriteNullIfExpression(node, context.get(), ExpressionTreeRewriter.this)) != null) {
                return result;
            }
            Expression first = ExpressionTreeRewriter.this.rewrite(node.getFirst(), context.get());
            Expression second = ExpressionTreeRewriter.this.rewrite(node.getSecond(), context.get());
            if (first != node.getFirst() || second != node.getSecond()) {
                return new NullIfExpression(first, second);
            }
            return node;
        }

        @Override
        protected Expression visitIfExpression(IfExpression node, Context<C> context) {
            Expression result;
            if (!context.isDefaultRewrite() && (result = ExpressionTreeRewriter.this.rewriter.rewriteIfExpression(node, context.get(), ExpressionTreeRewriter.this)) != null) {
                return result;
            }
            Expression condition = ExpressionTreeRewriter.this.rewrite(node.getCondition(), context.get());
            Expression trueValue = ExpressionTreeRewriter.this.rewrite(node.getTrueValue(), context.get());
            Expression falseValue = null;
            if (node.getFalseValue().isPresent()) {
                falseValue = ExpressionTreeRewriter.this.rewrite(node.getFalseValue().get(), context.get());
            }
            if (condition != node.getCondition() || trueValue != node.getTrueValue() || falseValue != node.getFalseValue().orElse(null)) {
                return new IfExpression(condition, trueValue, falseValue);
            }
            return node;
        }

        @Override
        protected Expression visitSearchedCaseExpression(SearchedCaseExpression node, Context<C> context) {
            Expression result;
            if (!context.isDefaultRewrite() && (result = ExpressionTreeRewriter.this.rewriter.rewriteSearchedCaseExpression(node, context.get(), ExpressionTreeRewriter.this)) != null) {
                return result;
            }
            ImmutableList.Builder builder = ImmutableList.builder();
            for (WhenClause expression : node.getWhenClauses()) {
                builder.add((Object)ExpressionTreeRewriter.this.rewrite(expression, context.get()));
            }
            Optional<Expression> defaultValue = node.getDefaultValue().map(value -> ExpressionTreeRewriter.this.rewrite(value, context.get()));
            if (!ExpressionTreeRewriter.sameElements(node.getDefaultValue(), defaultValue) || !ExpressionTreeRewriter.sameElements(node.getWhenClauses(), (Iterable)builder.build())) {
                return new SearchedCaseExpression((List<WhenClause>)builder.build(), defaultValue);
            }
            return node;
        }

        @Override
        protected Expression visitSimpleCaseExpression(SimpleCaseExpression node, Context<C> context) {
            Expression result;
            if (!context.isDefaultRewrite() && (result = ExpressionTreeRewriter.this.rewriter.rewriteSimpleCaseExpression(node, context.get(), ExpressionTreeRewriter.this)) != null) {
                return result;
            }
            Expression operand = ExpressionTreeRewriter.this.rewrite(node.getOperand(), context.get());
            ImmutableList.Builder builder = ImmutableList.builder();
            for (WhenClause expression : node.getWhenClauses()) {
                builder.add((Object)ExpressionTreeRewriter.this.rewrite(expression, context.get()));
            }
            Optional<Expression> defaultValue = node.getDefaultValue().map(value -> ExpressionTreeRewriter.this.rewrite(value, context.get()));
            if (operand != node.getOperand() || !ExpressionTreeRewriter.sameElements(node.getDefaultValue(), defaultValue) || !ExpressionTreeRewriter.sameElements(node.getWhenClauses(), (Iterable)builder.build())) {
                return new SimpleCaseExpression(operand, (List<WhenClause>)builder.build(), defaultValue);
            }
            return node;
        }

        @Override
        protected Expression visitWhenClause(WhenClause node, Context<C> context) {
            Expression result;
            if (!context.isDefaultRewrite() && (result = ExpressionTreeRewriter.this.rewriter.rewriteWhenClause(node, context.get(), ExpressionTreeRewriter.this)) != null) {
                return result;
            }
            Expression operand = ExpressionTreeRewriter.this.rewrite(node.getOperand(), context.get());
            Expression result2 = ExpressionTreeRewriter.this.rewrite(node.getResult(), context.get());
            if (operand != node.getOperand() || result2 != node.getResult()) {
                return new WhenClause(operand, result2);
            }
            return node;
        }

        @Override
        protected Expression visitCoalesceExpression(CoalesceExpression node, Context<C> context) {
            Expression result;
            if (!context.isDefaultRewrite() && (result = ExpressionTreeRewriter.this.rewriter.rewriteCoalesceExpression(node, context.get(), ExpressionTreeRewriter.this)) != null) {
                return result;
            }
            List operands = ExpressionTreeRewriter.this.rewrite((Expression)((Object)node.getOperands()), (Object)context);
            if (!ExpressionTreeRewriter.sameElements(node.getOperands(), operands)) {
                return new CoalesceExpression(operands);
            }
            return node;
        }

        @Override
        public Expression visitTryExpression(TryExpression node, Context<C> context) {
            Expression result;
            if (!context.isDefaultRewrite() && (result = ExpressionTreeRewriter.this.rewriter.rewriteTryExpression(node, context.get(), ExpressionTreeRewriter.this)) != null) {
                return result;
            }
            Expression expression = ExpressionTreeRewriter.this.rewrite(node.getInnerExpression(), context.get());
            if (node.getInnerExpression() != expression) {
                return new TryExpression(expression);
            }
            return node;
        }

        @Override
        public Expression visitFunctionCall(FunctionCall node, Context<C> context) {
            Window rewrittenWindow;
            Optional<Window> window;
            Expression result;
            if (!context.isDefaultRewrite() && (result = ExpressionTreeRewriter.this.rewriter.rewriteFunctionCall(node, context.get(), ExpressionTreeRewriter.this)) != null) {
                return result;
            }
            Optional<Expression> filter = node.getFilter();
            if (filter.isPresent()) {
                Expression filterExpression = filter.get();
                Expression newFilterExpression = ExpressionTreeRewriter.this.rewrite(filterExpression, context.get());
                filter = Optional.of(newFilterExpression);
            }
            if ((window = node.getWindow()).isPresent() && (rewrittenWindow = this.rewriteWindow(window.get(), context)) != window.get()) {
                window = Optional.of(rewrittenWindow);
            }
            List arguments = ExpressionTreeRewriter.this.rewrite((Expression)((Object)node.getArguments()), (Object)context);
            if (!(ExpressionTreeRewriter.sameElements(node.getArguments(), arguments) && ExpressionTreeRewriter.sameElements(window, node.getWindow()) && ExpressionTreeRewriter.sameElements(filter, node.getFilter()))) {
                return new FunctionCall(node.getLocation(), node.getName(), window, filter, node.getOrderBy().map(orderBy -> this.rewriteOrderBy((OrderBy)orderBy, context)), node.isDistinct(), node.getNullTreatment(), node.getProcessingMode(), arguments);
            }
            return node;
        }

        private OrderBy rewriteOrderBy(OrderBy orderBy, Context<C> context) {
            List<SortItem> rewrittenSortItems = this.rewriteSortItems(orderBy.getSortItems(), context);
            if (ExpressionTreeRewriter.sameElements(orderBy.getSortItems(), rewrittenSortItems)) {
                return orderBy;
            }
            return new OrderBy(rewrittenSortItems);
        }

        private List<SortItem> rewriteSortItems(List<SortItem> sortItems, Context<C> context) {
            ImmutableList.Builder rewrittenSortItems = ImmutableList.builder();
            for (SortItem sortItem : sortItems) {
                Expression sortKey = ExpressionTreeRewriter.this.rewrite(sortItem.getSortKey(), context.get());
                if (sortItem.getSortKey() != sortKey) {
                    rewrittenSortItems.add((Object)new SortItem(sortKey, sortItem.getOrdering(), sortItem.getNullOrdering()));
                    continue;
                }
                rewrittenSortItems.add((Object)sortItem);
            }
            return rewrittenSortItems.build();
        }

        private Window rewriteWindow(Window window, Context<C> context) {
            Optional<WindowFrame> rewrittenFrame;
            if (window instanceof WindowReference) {
                WindowReference windowReference = (WindowReference)window;
                Identifier rewrittenName = ExpressionTreeRewriter.this.rewrite(windowReference.getName(), context.get());
                if (windowReference.getName() != rewrittenName) {
                    return new WindowReference(rewrittenName);
                }
                return window;
            }
            WindowSpecification windowSpecification = (WindowSpecification)window;
            Optional<Identifier> existingWindowName = windowSpecification.getExistingWindowName().map(name -> ExpressionTreeRewriter.this.rewrite(name, context.get()));
            List partitionBy = ExpressionTreeRewriter.this.rewrite((Expression)((Object)windowSpecification.getPartitionBy()), (Object)context);
            Optional<OrderBy> orderBy = Optional.empty();
            if (windowSpecification.getOrderBy().isPresent()) {
                orderBy = Optional.of(this.rewriteOrderBy(windowSpecification.getOrderBy().get(), context));
            }
            if ((rewrittenFrame = windowSpecification.getFrame()).isPresent()) {
                Expression rewrittenValue;
                Optional<Expression> value;
                Optional<FrameBound> rewrittenEnd;
                Expression value2;
                WindowFrame frame = rewrittenFrame.get();
                FrameBound start = frame.getStart();
                if (start.getValue().isPresent() && (value2 = ExpressionTreeRewriter.this.rewrite(start.getValue().get(), context.get())) != start.getValue().get()) {
                    start = new FrameBound(start.getType(), value2);
                }
                if ((rewrittenEnd = frame.getEnd()).isPresent() && (value = rewrittenEnd.get().getValue()).isPresent() && (rewrittenValue = ExpressionTreeRewriter.this.rewrite(value.get(), context.get())) != value.get()) {
                    rewrittenEnd = Optional.of(new FrameBound(rewrittenEnd.get().getType(), rewrittenValue));
                }
                if (!frame.getMeasures().isEmpty() || frame.getAfterMatchSkipTo().isPresent() || frame.getPatternSearchMode().isPresent() || frame.getPattern().isPresent() || !frame.getSubsets().isEmpty() || !frame.getVariableDefinitions().isEmpty()) {
                    throw new UnsupportedOperationException("cannot rewrite pattern recognition clauses in window");
                }
                if (frame.getStart() != start || !ExpressionTreeRewriter.sameElements(frame.getEnd(), rewrittenEnd)) {
                    rewrittenFrame = Optional.of(new WindowFrame(frame.getType(), start, rewrittenEnd, frame.getMeasures(), frame.getAfterMatchSkipTo(), frame.getPatternSearchMode(), frame.getPattern(), frame.getSubsets(), frame.getVariableDefinitions()));
                }
            }
            if (!(ExpressionTreeRewriter.sameElements(windowSpecification.getExistingWindowName(), existingWindowName) && ExpressionTreeRewriter.sameElements(windowSpecification.getPartitionBy(), partitionBy) && ExpressionTreeRewriter.sameElements(windowSpecification.getOrderBy(), orderBy) && ExpressionTreeRewriter.sameElements(windowSpecification.getFrame(), rewrittenFrame))) {
                return new WindowSpecification(existingWindowName, partitionBy, orderBy, rewrittenFrame);
            }
            return window;
        }

        @Override
        protected Expression visitWindowOperation(WindowOperation node, Context<C> context) {
            Expression result;
            if (!context.isDefaultRewrite() && (result = ExpressionTreeRewriter.this.rewriter.rewriteWindowOperation(node, context.get(), ExpressionTreeRewriter.this)) != null) {
                return result;
            }
            Identifier name = ExpressionTreeRewriter.this.rewrite(node.getName(), context.get());
            Window window = this.rewriteWindow(node.getWindow(), context);
            if (name != node.getName() || window != node.getWindow()) {
                return new WindowOperation(name, window);
            }
            return node;
        }

        @Override
        protected Expression visitLambdaExpression(LambdaExpression node, Context<C> context) {
            Expression result;
            if (!context.isDefaultRewrite() && (result = ExpressionTreeRewriter.this.rewriter.rewriteLambdaExpression(node, context.get(), ExpressionTreeRewriter.this)) != null) {
                return result;
            }
            Expression body = ExpressionTreeRewriter.this.rewrite(node.getBody(), context.get());
            if (body != node.getBody()) {
                return new LambdaExpression(node.getArguments(), body);
            }
            return node;
        }

        @Override
        protected Expression visitBindExpression(BindExpression node, Context<C> context) {
            Expression result;
            if (!context.isDefaultRewrite() && (result = ExpressionTreeRewriter.this.rewriter.rewriteBindExpression(node, context.get(), ExpressionTreeRewriter.this)) != null) {
                return result;
            }
            List values = (List)node.getValues().stream().map(value -> ExpressionTreeRewriter.this.rewrite(value, context.get())).collect(ImmutableList.toImmutableList());
            Expression function = ExpressionTreeRewriter.this.rewrite(node.getFunction(), context.get());
            if (!ExpressionTreeRewriter.sameElements(values, node.getValues()) || function != node.getFunction()) {
                return new BindExpression(values, function);
            }
            return node;
        }

        @Override
        public Expression visitLikePredicate(LikePredicate node, Context<C> context) {
            Expression result;
            if (!context.isDefaultRewrite() && (result = ExpressionTreeRewriter.this.rewriter.rewriteLikePredicate(node, context.get(), ExpressionTreeRewriter.this)) != null) {
                return result;
            }
            Expression value = ExpressionTreeRewriter.this.rewrite(node.getValue(), context.get());
            Expression pattern = ExpressionTreeRewriter.this.rewrite(node.getPattern(), context.get());
            Optional<Expression> rewrittenEscape = node.getEscape().map(escape -> ExpressionTreeRewriter.this.rewrite(escape, context.get()));
            if (value != node.getValue() || pattern != node.getPattern() || !ExpressionTreeRewriter.sameElements(node.getEscape(), rewrittenEscape)) {
                return new LikePredicate(value, pattern, rewrittenEscape);
            }
            return node;
        }

        @Override
        public Expression visitInPredicate(InPredicate node, Context<C> context) {
            Expression result;
            if (!context.isDefaultRewrite() && (result = ExpressionTreeRewriter.this.rewriter.rewriteInPredicate(node, context.get(), ExpressionTreeRewriter.this)) != null) {
                return result;
            }
            Expression value = ExpressionTreeRewriter.this.rewrite(node.getValue(), context.get());
            Expression list = ExpressionTreeRewriter.this.rewrite(node.getValueList(), context.get());
            if (node.getValue() != value || node.getValueList() != list) {
                return new InPredicate(value, list);
            }
            return node;
        }

        @Override
        protected Expression visitInListExpression(InListExpression node, Context<C> context) {
            Expression result;
            if (!context.isDefaultRewrite() && (result = ExpressionTreeRewriter.this.rewriter.rewriteInListExpression(node, context.get(), ExpressionTreeRewriter.this)) != null) {
                return result;
            }
            List values = ExpressionTreeRewriter.this.rewrite((Expression)((Object)node.getValues()), (Object)context);
            if (!ExpressionTreeRewriter.sameElements(node.getValues(), values)) {
                return new InListExpression(values);
            }
            return node;
        }

        @Override
        protected Expression visitExists(ExistsPredicate node, Context<C> context) {
            Expression result;
            if (!context.isDefaultRewrite() && (result = ExpressionTreeRewriter.this.rewriter.rewriteExists(node, context.get(), ExpressionTreeRewriter.this)) != null) {
                return result;
            }
            Expression subquery = node.getSubquery();
            if ((subquery = ExpressionTreeRewriter.this.rewrite(subquery, context.get())) != node.getSubquery()) {
                return new ExistsPredicate(subquery);
            }
            return node;
        }

        @Override
        public Expression visitSubqueryExpression(SubqueryExpression node, Context<C> context) {
            Expression result;
            if (!context.isDefaultRewrite() && (result = ExpressionTreeRewriter.this.rewriter.rewriteSubqueryExpression(node, context.get(), ExpressionTreeRewriter.this)) != null) {
                return result;
            }
            return node;
        }

        @Override
        public Expression visitLiteral(Literal node, Context<C> context) {
            Expression result;
            if (!context.isDefaultRewrite() && (result = ExpressionTreeRewriter.this.rewriter.rewriteLiteral(node, context.get(), ExpressionTreeRewriter.this)) != null) {
                return result;
            }
            return node;
        }

        @Override
        public Expression visitParameter(Parameter node, Context<C> context) {
            Expression result;
            if (!context.isDefaultRewrite() && (result = ExpressionTreeRewriter.this.rewriter.rewriteParameter(node, context.get(), ExpressionTreeRewriter.this)) != null) {
                return result;
            }
            return node;
        }

        @Override
        public Expression visitIdentifier(Identifier node, Context<C> context) {
            Expression result;
            if (!context.isDefaultRewrite() && (result = ExpressionTreeRewriter.this.rewriter.rewriteIdentifier(node, context.get(), ExpressionTreeRewriter.this)) != null) {
                return result;
            }
            return node;
        }

        @Override
        public Expression visitDereferenceExpression(DereferenceExpression node, Context<C> context) {
            Expression result;
            if (!context.isDefaultRewrite() && (result = ExpressionTreeRewriter.this.rewriter.rewriteDereferenceExpression(node, context.get(), ExpressionTreeRewriter.this)) != null) {
                return result;
            }
            Expression base = ExpressionTreeRewriter.this.rewrite(node.getBase(), context.get());
            if (base != node.getBase()) {
                if (node.getField().isPresent()) {
                    return new DereferenceExpression(base, node.getField().get());
                }
                return new DereferenceExpression((Identifier)base);
            }
            return node;
        }

        @Override
        protected Expression visitExtract(Extract node, Context<C> context) {
            Expression result;
            if (!context.isDefaultRewrite() && (result = ExpressionTreeRewriter.this.rewriter.rewriteExtract(node, context.get(), ExpressionTreeRewriter.this)) != null) {
                return result;
            }
            Expression expression = ExpressionTreeRewriter.this.rewrite(node.getExpression(), context.get());
            if (node.getExpression() != expression) {
                return new Extract(expression, node.getField());
            }
            return node;
        }

        @Override
        protected Expression visitCurrentTime(CurrentTime node, Context<C> context) {
            Expression result;
            if (!context.isDefaultRewrite() && (result = ExpressionTreeRewriter.this.rewriter.rewriteCurrentTime(node, context.get(), ExpressionTreeRewriter.this)) != null) {
                return result;
            }
            return node;
        }

        @Override
        public Expression visitCast(Cast node, Context<C> context) {
            Expression result;
            if (!context.isDefaultRewrite() && (result = ExpressionTreeRewriter.this.rewriter.rewriteCast(node, context.get(), ExpressionTreeRewriter.this)) != null) {
                return result;
            }
            Expression expression = ExpressionTreeRewriter.this.rewrite(node.getExpression(), context.get());
            DataType type = ExpressionTreeRewriter.this.rewrite(node.getType(), context.get());
            if (node.getExpression() != expression || node.getType() != type) {
                return new Cast(expression, type, node.isSafe(), node.isTypeOnly());
            }
            return node;
        }

        @Override
        protected Expression visitRowDataType(RowDataType node, Context<C> context) {
            Expression result;
            if (!context.isDefaultRewrite() && (result = ExpressionTreeRewriter.this.rewriter.rewriteRowDataType(node, context.get(), ExpressionTreeRewriter.this)) != null) {
                return result;
            }
            ImmutableList.Builder rewritten = ImmutableList.builder();
            for (RowDataType.Field field : node.getFields()) {
                boolean nameRewritten;
                Identifier rewrittenIdentifier;
                Identifier identifier;
                DataType dataType = ExpressionTreeRewriter.this.rewrite(field.getType(), context.get());
                Optional<Identifier> name = field.getName();
                if (field.getName().isPresent() && (identifier = field.getName().get()) != (rewrittenIdentifier = ExpressionTreeRewriter.this.rewrite(identifier, context.get()))) {
                    name = Optional.of(rewrittenIdentifier);
                }
                boolean bl = nameRewritten = name != field.getName();
                if (dataType != field.getType() || nameRewritten) {
                    rewritten.add((Object)new RowDataType.Field(field.getLocation(), name, dataType));
                    continue;
                }
                rewritten.add((Object)field);
            }
            ImmutableList fields = rewritten.build();
            if (!ExpressionTreeRewriter.sameElements((Iterable)fields, node.getFields())) {
                return new RowDataType(node.getLocation(), (List<RowDataType.Field>)fields);
            }
            return node;
        }

        @Override
        protected Expression visitGenericDataType(GenericDataType node, Context<C> context) {
            Expression result;
            if (!context.isDefaultRewrite() && (result = ExpressionTreeRewriter.this.rewriter.rewriteGenericDataType(node, context.get(), ExpressionTreeRewriter.this)) != null) {
                return result;
            }
            Identifier name = ExpressionTreeRewriter.this.rewrite(node.getName(), context.get());
            ImmutableList.Builder arguments = ImmutableList.builder();
            for (DataTypeParameter argument : node.getArguments()) {
                if (argument instanceof NumericParameter) {
                    arguments.add((Object)argument);
                    continue;
                }
                if (!(argument instanceof TypeParameter)) continue;
                TypeParameter parameter = (TypeParameter)argument;
                DataType value = (DataType)this.process(parameter.getValue(), context);
                if (value != parameter.getValue()) {
                    arguments.add((Object)new TypeParameter(value));
                    continue;
                }
                arguments.add((Object)argument);
            }
            ImmutableList rewrittenArguments = arguments.build();
            if (name != node.getName() || !ExpressionTreeRewriter.sameElements((Iterable)rewrittenArguments, node.getArguments())) {
                return new GenericDataType(node.getLocation(), name, (List<DataTypeParameter>)rewrittenArguments);
            }
            return node;
        }

        @Override
        protected Expression visitIntervalDataType(IntervalDayTimeDataType node, Context<C> context) {
            Expression result;
            if (!context.isDefaultRewrite() && (result = ExpressionTreeRewriter.this.rewriter.rewriteIntervalDayTimeDataType(node, context.get(), ExpressionTreeRewriter.this)) != null) {
                return result;
            }
            return node;
        }

        @Override
        protected Expression visitDateTimeType(DateTimeDataType node, Context<C> context) {
            Expression result;
            if (!context.isDefaultRewrite() && (result = ExpressionTreeRewriter.this.rewriter.rewriteDateTimeDataType(node, context.get(), ExpressionTreeRewriter.this)) != null) {
                return result;
            }
            return node;
        }

        @Override
        protected Expression visitFieldReference(FieldReference node, Context<C> context) {
            Expression result;
            if (!context.isDefaultRewrite() && (result = ExpressionTreeRewriter.this.rewriter.rewriteFieldReference(node, context.get(), ExpressionTreeRewriter.this)) != null) {
                return result;
            }
            return node;
        }

        @Override
        protected Expression visitSymbolReference(SymbolReference node, Context<C> context) {
            Expression result;
            if (!context.isDefaultRewrite() && (result = ExpressionTreeRewriter.this.rewriter.rewriteSymbolReference(node, context.get(), ExpressionTreeRewriter.this)) != null) {
                return result;
            }
            return node;
        }

        @Override
        protected Expression visitQuantifiedComparisonExpression(QuantifiedComparisonExpression node, Context<C> context) {
            Expression result;
            if (!context.isDefaultRewrite() && (result = ExpressionTreeRewriter.this.rewriter.rewriteQuantifiedComparison(node, context.get(), ExpressionTreeRewriter.this)) != null) {
                return result;
            }
            Expression value = ExpressionTreeRewriter.this.rewrite(node.getValue(), context.get());
            Expression subquery = ExpressionTreeRewriter.this.rewrite(node.getSubquery(), context.get());
            if (node.getValue() != value || node.getSubquery() != subquery) {
                return new QuantifiedComparisonExpression(node.getOperator(), node.getQuantifier(), value, subquery);
            }
            return node;
        }

        @Override
        public Expression visitGroupingOperation(GroupingOperation node, Context<C> context) {
            Expression result;
            if (!context.isDefaultRewrite() && (result = ExpressionTreeRewriter.this.rewriter.rewriteGroupingOperation(node, context.get(), ExpressionTreeRewriter.this)) != null) {
                return result;
            }
            return node;
        }

        @Override
        protected Expression visitCurrentCatalog(CurrentCatalog node, Context<C> context) {
            Expression result;
            if (!context.isDefaultRewrite() && (result = ExpressionTreeRewriter.this.rewriter.rewriteCurrentCatalog(node, context.get(), ExpressionTreeRewriter.this)) != null) {
                return result;
            }
            return node;
        }

        @Override
        protected Expression visitCurrentSchema(CurrentSchema node, Context<C> context) {
            Expression result;
            if (!context.isDefaultRewrite() && (result = ExpressionTreeRewriter.this.rewriter.rewriteCurrentSchema(node, context.get(), ExpressionTreeRewriter.this)) != null) {
                return result;
            }
            return node;
        }

        @Override
        protected Expression visitCurrentUser(CurrentUser node, Context<C> context) {
            Expression result;
            if (!context.isDefaultRewrite() && (result = ExpressionTreeRewriter.this.rewriter.rewriteCurrentUser(node, context.get(), ExpressionTreeRewriter.this)) != null) {
                return result;
            }
            return node;
        }

        @Override
        protected Expression visitCurrentPath(CurrentPath node, Context<C> context) {
            Expression result;
            if (!context.isDefaultRewrite() && (result = ExpressionTreeRewriter.this.rewriter.rewriteCurrentPath(node, context.get(), ExpressionTreeRewriter.this)) != null) {
                return result;
            }
            return node;
        }

        @Override
        protected Expression visitFormat(Format node, Context<C> context) {
            Expression result;
            if (!context.isDefaultRewrite() && (result = ExpressionTreeRewriter.this.rewriter.rewriteFormat(node, context.get(), ExpressionTreeRewriter.this)) != null) {
                return result;
            }
            List arguments = ExpressionTreeRewriter.this.rewrite((Expression)((Object)node.getArguments()), (Object)context);
            if (!ExpressionTreeRewriter.sameElements(node.getArguments(), arguments)) {
                return new Format(arguments);
            }
            return node;
        }

        @Override
        protected Expression visitLabelDereference(LabelDereference node, Context<C> context) {
            Expression result;
            if (!context.isDefaultRewrite() && (result = ExpressionTreeRewriter.this.rewriter.rewriteLabelDereference(node, context.get(), ExpressionTreeRewriter.this)) != null) {
                return result;
            }
            if (node.getReference().isPresent()) {
                SymbolReference reference = ExpressionTreeRewriter.this.rewrite(node.getReference().get(), context.get());
                if (node.getReference().get() != reference) {
                    return new LabelDereference(node.getLabel(), reference);
                }
            }
            return node;
        }
    }
}

