/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.tree;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.trino.sql.tree.AstVisitor;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.FetchFirst;
import io.trino.sql.tree.GroupBy;
import io.trino.sql.tree.Limit;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.NodeLocation;
import io.trino.sql.tree.Offset;
import io.trino.sql.tree.OrderBy;
import io.trino.sql.tree.QueryBody;
import io.trino.sql.tree.Relation;
import io.trino.sql.tree.Select;
import io.trino.sql.tree.WindowDefinition;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class QuerySpecification
extends QueryBody {
    private final Select select;
    private final Optional<Relation> from;
    private final Optional<Expression> where;
    private final Optional<GroupBy> groupBy;
    private final Optional<Expression> having;
    private final List<WindowDefinition> windows;
    private final Optional<OrderBy> orderBy;
    private final Optional<Offset> offset;
    private final Optional<Node> limit;

    public QuerySpecification(Select select, Optional<Relation> from, Optional<Expression> where, Optional<GroupBy> groupBy, Optional<Expression> having, List<WindowDefinition> windows, Optional<OrderBy> orderBy, Optional<Offset> offset, Optional<Node> limit) {
        this(Optional.empty(), select, from, where, groupBy, having, windows, orderBy, offset, limit);
    }

    public QuerySpecification(NodeLocation location, Select select, Optional<Relation> from, Optional<Expression> where, Optional<GroupBy> groupBy, Optional<Expression> having, List<WindowDefinition> windows, Optional<OrderBy> orderBy, Optional<Offset> offset, Optional<Node> limit) {
        this(Optional.of(location), select, from, where, groupBy, having, windows, orderBy, offset, limit);
    }

    private QuerySpecification(Optional<NodeLocation> location, Select select, Optional<Relation> from, Optional<Expression> where, Optional<GroupBy> groupBy, Optional<Expression> having, List<WindowDefinition> windows, Optional<OrderBy> orderBy, Optional<Offset> offset, Optional<Node> limit) {
        super(location);
        Objects.requireNonNull(select, "select is null");
        Objects.requireNonNull(from, "from is null");
        Objects.requireNonNull(where, "where is null");
        Objects.requireNonNull(groupBy, "groupBy is null");
        Objects.requireNonNull(having, "having is null");
        Objects.requireNonNull(windows, "windows is null");
        Objects.requireNonNull(orderBy, "orderBy is null");
        Objects.requireNonNull(offset, "offset is null");
        Objects.requireNonNull(limit, "limit is null");
        Preconditions.checkArgument((!limit.isPresent() || limit.get() instanceof FetchFirst || limit.get() instanceof Limit ? 1 : 0) != 0, (Object)"limit must be optional of either FetchFirst or Limit type");
        this.select = select;
        this.from = from;
        this.where = where;
        this.groupBy = groupBy;
        this.having = having;
        this.windows = windows;
        this.orderBy = orderBy;
        this.offset = offset;
        this.limit = limit;
    }

    public Select getSelect() {
        return this.select;
    }

    public Optional<Relation> getFrom() {
        return this.from;
    }

    public Optional<Expression> getWhere() {
        return this.where;
    }

    public Optional<GroupBy> getGroupBy() {
        return this.groupBy;
    }

    public Optional<Expression> getHaving() {
        return this.having;
    }

    public List<WindowDefinition> getWindows() {
        return this.windows;
    }

    public Optional<OrderBy> getOrderBy() {
        return this.orderBy;
    }

    public Optional<Offset> getOffset() {
        return this.offset;
    }

    public Optional<Node> getLimit() {
        return this.limit;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitQuerySpecification(this, context);
    }

    public List<Node> getChildren() {
        ImmutableList.Builder nodes = ImmutableList.builder();
        nodes.add((Object)this.select);
        this.from.ifPresent(arg_0 -> ((ImmutableList.Builder)nodes).add(arg_0));
        this.where.ifPresent(arg_0 -> ((ImmutableList.Builder)nodes).add(arg_0));
        this.groupBy.ifPresent(arg_0 -> ((ImmutableList.Builder)nodes).add(arg_0));
        this.having.ifPresent(arg_0 -> ((ImmutableList.Builder)nodes).add(arg_0));
        nodes.addAll(this.windows);
        this.orderBy.ifPresent(arg_0 -> ((ImmutableList.Builder)nodes).add(arg_0));
        this.offset.ifPresent(arg_0 -> ((ImmutableList.Builder)nodes).add(arg_0));
        this.limit.ifPresent(arg_0 -> ((ImmutableList.Builder)nodes).add(arg_0));
        return nodes.build();
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("select", (Object)this.select).add("from", this.from).add("where", this.where.orElse(null)).add("groupBy", this.groupBy).add("having", this.having.orElse(null)).add("windows", this.windows.isEmpty() ? null : this.windows).add("orderBy", this.orderBy).add("offset", this.offset.orElse(null)).add("limit", this.limit.orElse(null)).toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        QuerySpecification o = (QuerySpecification)obj;
        return Objects.equals(this.select, o.select) && Objects.equals(this.from, o.from) && Objects.equals(this.where, o.where) && Objects.equals(this.groupBy, o.groupBy) && Objects.equals(this.having, o.having) && Objects.equals(this.windows, o.windows) && Objects.equals(this.orderBy, o.orderBy) && Objects.equals(this.offset, o.offset) && Objects.equals(this.limit, o.limit);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.select, this.from, this.where, this.groupBy, this.having, this.windows, this.orderBy, this.offset, this.limit);
    }

    @Override
    public boolean shallowEquals(Node other) {
        return QuerySpecification.sameClass(this, other);
    }
}

